﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>

namespace nn { namespace lm { namespace detail {

const size_t LogPacketHeaderSize = 24;

class LogPacketHeader
{
public:
private:
    static const int IsHeadBitOffset            = 0;
    static const int IsTailBitOffset            = 1;
    static const int IsLittleEndianBitOffset    = 2;
private:
    uint64_t    m_ProcessId;
    uint64_t    m_ThreadId;
    uint8_t     m_Flags;
    uint8_t     m_Padding NN_IS_UNUSED_MEMBER;
    uint8_t     m_Severity;
    uint8_t     m_Verbosity;
    uint32_t    m_PayloadSize;
public:
    uint64_t    GetProcessId() const NN_NOEXCEPT;
    void        SetProcessId(uint64_t value) NN_NOEXCEPT;
    uint64_t    GetThreadId() const NN_NOEXCEPT;
    void        SetThreadId(uint64_t value) NN_NOEXCEPT;
    bool        IsHead() const NN_NOEXCEPT;
    void        SetHead(bool isHead) NN_NOEXCEPT;
    bool        IsTail() const NN_NOEXCEPT;
    void        SetTail(bool isTail) NN_NOEXCEPT;
    bool        IsLittleEndian() const NN_NOEXCEPT;
    void        SetLittleEndian(bool isLittleEndian) NN_NOEXCEPT;
    uint8_t     GetSeverity() const NN_NOEXCEPT;
    void        SetSeverity(uint8_t severity) NN_NOEXCEPT;
    uint8_t     GetVerbosity() const NN_NOEXCEPT;
    void        SetVerbosity(uint8_t verbosity) NN_NOEXCEPT;
    uint32_t    GetPayloadSize() const NN_NOEXCEPT;
    void        SetPayloadSize(uint32_t size) NN_NOEXCEPT;
};

NN_STATIC_ASSERT(sizeof(LogPacketHeader) == LogPacketHeaderSize);

}}} // nn::lm::detail
