﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "lm_LogPacketHeader.h"

namespace nn { namespace lm { namespace detail {

uint64_t LogPacketHeader::GetProcessId() const NN_NOEXCEPT
{
    return m_ProcessId;
}

void LogPacketHeader::SetProcessId(uint64_t value) NN_NOEXCEPT
{
    m_ProcessId = value;
}

uint64_t LogPacketHeader::GetThreadId() const NN_NOEXCEPT
{
    return m_ThreadId;
}

void LogPacketHeader::SetThreadId(uint64_t value) NN_NOEXCEPT
{
    m_ThreadId = value;
}

bool LogPacketHeader::IsHead() const NN_NOEXCEPT
{
    return (m_Flags & (1 << IsHeadBitOffset)) != 0;
}

void LogPacketHeader::SetHead(bool isHead) NN_NOEXCEPT
{
    auto mask = static_cast<uint8_t>(1 << IsHeadBitOffset);
    m_Flags = (m_Flags & (~mask)) | (isHead ? mask : 0);
}

bool LogPacketHeader::IsTail() const NN_NOEXCEPT
{
    return (m_Flags & (1 << IsTailBitOffset)) != 0;
}

void LogPacketHeader::SetTail(bool isTail) NN_NOEXCEPT
{
    auto mask = static_cast<uint8_t>(1 << IsTailBitOffset);
    m_Flags = (m_Flags & (~mask)) | (isTail ? mask : 0);
}

bool LogPacketHeader::IsLittleEndian() const NN_NOEXCEPT
{
    return (m_Flags & (1 << IsLittleEndianBitOffset)) != 0;
}

void LogPacketHeader::SetLittleEndian(bool isLittleEndian) NN_NOEXCEPT
{
    auto mask = static_cast<uint8_t>(1 << IsLittleEndianBitOffset);
    m_Flags = (m_Flags & (~mask)) | (isLittleEndian ? mask : 0);
}

uint8_t LogPacketHeader::GetSeverity() const NN_NOEXCEPT
{
    return m_Severity;
}

void LogPacketHeader::SetSeverity(uint8_t severity) NN_NOEXCEPT
{
    m_Severity = severity;
}

uint8_t LogPacketHeader::GetVerbosity() const NN_NOEXCEPT
{
    return m_Verbosity;
}

void LogPacketHeader::SetVerbosity(uint8_t verbosity) NN_NOEXCEPT
{
    m_Verbosity = verbosity;
}

uint32_t LogPacketHeader::GetPayloadSize() const NN_NOEXCEPT
{
    return m_PayloadSize;
}

void LogPacketHeader::SetPayloadSize(uint32_t size) NN_NOEXCEPT
{
    m_PayloadSize = size;
}

}}} // nn::lm::detail
