﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      lm モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_LM_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(lm, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_LM_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_LM_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_LM_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_LM_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(lm, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_LM_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lm, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_LM_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lm, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_LM_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lm, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_LM_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(lm, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_LM_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lm, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_LM_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lm, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_LM_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(lm, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_LM_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(lm, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_LM_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_LM_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_LM_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_LM_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(lm, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_LM_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_LM_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_LM_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(lm, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_LM_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Trace, 0, format, args)
#define NN_DETAIL_LM_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Trace, 1, format, args)
#define NN_DETAIL_LM_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Trace, 2, format, args)
#define NN_DETAIL_LM_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Trace, 3, format, args)

#define NN_DETAIL_LM_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Info, 0, format, args)
#define NN_DETAIL_LM_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Info, 1, format, args)
#define NN_DETAIL_LM_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Info, 2, format, args)
#define NN_DETAIL_LM_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Info, 3, format, args)

#define NN_DETAIL_LM_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Warn, 0, format, args)
#define NN_DETAIL_LM_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Warn, 1, format, args)
#define NN_DETAIL_LM_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Warn, 2, format, args)
#define NN_DETAIL_LM_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Warn, 3, format, args)

#define NN_DETAIL_LM_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Error, 0, format, args)
#define NN_DETAIL_LM_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Error, 1, format, args)
#define NN_DETAIL_LM_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Error, 2, format, args)
#define NN_DETAIL_LM_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Error, 3, format, args)

#define NN_DETAIL_LM_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Fatal, 0, format, args)
#define NN_DETAIL_LM_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Fatal, 1, format, args)
#define NN_DETAIL_LM_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Fatal, 2, format, args)
#define NN_DETAIL_LM_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(lm, Fatal, 3, format, args)

#define NN_DETAIL_LM_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(lm, Trace, 0, text, length)
#define NN_DETAIL_LM_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Trace, 1, text, length)
#define NN_DETAIL_LM_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Trace, 2, text, length)
#define NN_DETAIL_LM_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Trace, 3, text, length)

#define NN_DETAIL_LM_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(lm, Info, 0, text, length)
#define NN_DETAIL_LM_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lm, Info, 1, text, length)
#define NN_DETAIL_LM_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lm, Info, 2, text, length)
#define NN_DETAIL_LM_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lm, Info, 3, text, length)

#define NN_DETAIL_LM_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(lm, Warn, 0, text, length)
#define NN_DETAIL_LM_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lm, Warn, 1, text, length)
#define NN_DETAIL_LM_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lm, Warn, 2, text, length)
#define NN_DETAIL_LM_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(lm, Warn, 3, text, length)

#define NN_DETAIL_LM_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(lm, Error, 0, text, length)
#define NN_DETAIL_LM_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Error, 1, text, length)
#define NN_DETAIL_LM_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Error, 2, text, length)
#define NN_DETAIL_LM_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Error, 3, text, length)

#define NN_DETAIL_LM_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(lm, Fatal, 0, text, length)
#define NN_DETAIL_LM_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Fatal, 1, text, length)
#define NN_DETAIL_LM_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Fatal, 2, text, length)
#define NN_DETAIL_LM_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(lm, Fatal, 3, text, length)
