﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/lbl/lbl_Type.h>
#include <nn/lbl/detail/lbl_ILblController.h>


namespace nn { namespace lbl { namespace server {

// ILblController 実装クラス
class LblControllerImpl
    : public nn::sf::ISharedObject
{

public:

    LblControllerImpl() NN_NOEXCEPT;
    ~LblControllerImpl() NN_NOEXCEPT;

    void SaveCurrentSetting() NN_NOEXCEPT;
    void LoadCurrentSetting() NN_NOEXCEPT;
    void SetCurrentBrightnessSetting(float brightnessSetting) NN_NOEXCEPT;
    float GetCurrentBrightnessSetting() NN_NOEXCEPT;
    void SetCurrentBrightnessSettingForVrMode(float brightnessSetting) NN_NOEXCEPT;
    float GetCurrentBrightnessSettingForVrMode() NN_NOEXCEPT;

    void ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT;
    float GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT;

    void SwitchBacklightOn(nn::TimeSpan fadeInTime) NN_NOEXCEPT;
    void SwitchBacklightOff(nn::TimeSpan fadeOutTime) NN_NOEXCEPT;
    std::int32_t GetBacklightSwitchStatus() NN_NOEXCEPT;

    void EnableDimming() NN_NOEXCEPT;
    void DisableDimming() NN_NOEXCEPT;
    bool IsDimmingEnabled() NN_NOEXCEPT;

    void EnableVrMode() NN_NOEXCEPT;
    void DisableVrMode() NN_NOEXCEPT;
    bool IsVrModeEnabled() NN_NOEXCEPT;

    void EnableAutoBrightnessControl() NN_NOEXCEPT;
    void DisableAutoBrightnessControl() NN_NOEXCEPT;
    bool IsAutoBrightnessControlEnabled() NN_NOEXCEPT;

    void SetAmbientLightSensorValue(float sensorValue) NN_NOEXCEPT;
    float GetAmbientLightSensorValue(nn::sf::Out<bool> outOverflowAlert) NN_NOEXCEPT;
    bool IsAmbientLightSensorAvailable() NN_NOEXCEPT;

    void SetBrightnessReflectionDelayLevel(std::int32_t direction, float delayLevel) NN_NOEXCEPT;
    float GetBrightnessReflectionDelayLevel(std::int32_t direction) NN_NOEXCEPT;

    void SetCurrentBrightnessMapping(MappingCoefficient brightnessMapping) NN_NOEXCEPT;
    void GetCurrentBrightnessMapping(nn::sf::Out<MappingCoefficient> brightnessMapping) NN_NOEXCEPT;
    void SetCurrentAmbientLightSensorMapping(MappingCoefficient sensorMapping) NN_NOEXCEPT;
    void GetCurrentAmbientLightSensorMapping(nn::sf::Out<MappingCoefficient> sensorMapping) NN_NOEXCEPT;

private:

};


}}}
