﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/lbl/impl/lbl.h>

namespace nn {
namespace lbl {
namespace impl {

void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

void SaveCurrentSetting() NN_NOEXCEPT
{
}

void LoadCurrentSetting() NN_NOEXCEPT
{
}

void SetCurrentBrightnessSetting(float brightnessSetting) NN_NOEXCEPT
{
    NN_UNUSED( brightnessSetting );
}

float GetCurrentBrightnessSetting() NN_NOEXCEPT
{
    return 0.0f;
}

void ApplyCurrentBrightnessSettingToBacklight() NN_NOEXCEPT
{
}

float GetBrightnessSettingAppliedToBacklight() NN_NOEXCEPT
{
    return 0.0f;
}

void SwitchBacklightOn(nn::TimeSpan fadeInTime) NN_NOEXCEPT
{
    NN_UNUSED( fadeInTime );
}

void SwitchBacklightOff(nn::TimeSpan fadeOutTime) NN_NOEXCEPT
{
    NN_UNUSED( fadeOutTime );
}

BacklightSwitchStatus GetBacklightSwitchStatus() NN_NOEXCEPT
{
    return BacklightSwitchStatus_OffWithStability;
}

void EnableDimming() NN_NOEXCEPT
{
}

void DisableDimming() NN_NOEXCEPT
{
}

bool IsDimmingEnabled() NN_NOEXCEPT
{
    return false;
}

void EnableAutoBrightnessControl() NN_NOEXCEPT
{
}

void DisableAutoBrightnessControl() NN_NOEXCEPT
{
}

bool IsAutoBrightnessControlEnabled() NN_NOEXCEPT
{
    return false;
}

void SetAmbientLightSensorValue(float sensorValue) NN_NOEXCEPT
{
    NN_UNUSED( sensorValue );
}

float GetAmbientLightSensorValue(bool* pOutOverflowAlert) NN_NOEXCEPT
{
    NN_UNUSED( pOutOverflowAlert );
    return 0.0f;
}

void SetCurrentAmbientLightSensorMapping(const MappingCoefficient& sensorMapping) NN_NOEXCEPT
{
    NN_UNUSED( sensorMapping );
}

void GetCurrentAmbientLightSensorMapping(MappingCoefficient* pSensorMapping) NN_NOEXCEPT
{
    NN_UNUSED( pSensorMapping );
}

} // impl
} // lbl
} // nn
