﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   自動輝度調整のアルゴリズムです。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace lbl { namespace impl { namespace detail {

class AutoBrightnessAdjuster
{
public:
    AutoBrightnessAdjuster() NN_NOEXCEPT {}

    /**
    * @brief   照度センサー値と現在の輝度設定値、
    *          内部の状態変数に基いて自動輝度調整有効時の輝度値を更新します。
    */
    float UpdateForAutoBrightness(float sensor, float brightness, bool applyNow);

    /**
    * @brief   自動輝度調整無効時の輝度値更新関数です。
    */
    float UpdateForManualBrightness( float brightness );

    /**
    * @brief   自動輝度調整無効時の最低輝度レベルです。
    */
    float GetMinManualBrightness() const;
};

}}}} // nn::lbl::impl::detail
