﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ライブラリアプレットの共通引数の受け渡しをおこなうクラスの実装
 */

#include <nn/la/la_NifmToNetConnectArgumentsWriter.h>

#include <nn/applet/applet.h>

#include <nn/nn_Macro.h>
#include <nn/nn_SdkLog.h>

#include <nn/la/la_Configs.h>
#include <nn/la/la_Result.h>

#include <nn/util/util_StringUtil.h>


namespace nn { namespace la {

namespace {

static const uint32_t CurrentNifmToNetConnectVersion = NN_DETAIL_LA_CURRENT_NIFMTONETCONNECT_VERSION;

}

NifmToNetConnectArgumentsWriter::NifmToNetConnectArgumentsWriter(const Result result, const nn::util::Uuid& uuid) NN_NOEXCEPT
{
    m_NifmToNetConnectArgumentsData.networkConnectionResult = result;
    m_NifmToNetConnectArgumentsData.networkProfileId = uuid;
}

NifmToNetConnectArgumentsWriter::~NifmToNetConnectArgumentsWriter() NN_NOEXCEPT
{
}

void NifmToNetConnectArgumentsWriter::PushToInChannel(nn::applet::LibraryAppletHandle libraryAppletHandle) const NN_NOEXCEPT
{
    nn::applet::StorageHandle storageHandle;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::CreateStorage(&storageHandle, sizeof(CurrentNifmToNetConnectVersion) + sizeof(m_NifmToNetConnectArgumentsData)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::WriteToStorage(storageHandle, 0, &CurrentNifmToNetConnectVersion, sizeof(CurrentNifmToNetConnectVersion)));
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::applet::WriteToStorage(storageHandle, sizeof(CurrentNifmToNetConnectVersion), &m_NifmToNetConnectArgumentsData, sizeof(m_NifmToNetConnectArgumentsData)));
    nn::applet::PushToInChannel(libraryAppletHandle, storageHandle);
}

size_t NifmToNetConnectArgumentsWriter::GetExportSize() const NN_NOEXCEPT
{
    return sizeof(CurrentNifmToNetConnectVersion) + sizeof(m_NifmToNetConnectArgumentsData);
}

void NifmToNetConnectArgumentsWriter::Export(char buffer[], size_t size) const NN_NOEXCEPT
{
    NN_ABORT_UNLESS_GREATER_EQUAL(size, GetExportSize());

    std::memcpy(&buffer[0], &CurrentNifmToNetConnectVersion, sizeof(CurrentNifmToNetConnectVersion));
    std::memcpy(&buffer[sizeof(CurrentNifmToNetConnectVersion)], &m_NifmToNetConnectArgumentsData, sizeof(m_NifmToNetConnectArgumentsData));
}

}} // namespace nn::la

