﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include "idle_IHandler.h"

namespace nn { namespace idle { namespace server {

    class HandlerImplSleeper final : public IHandler
    {
    public:
        HandlerImplSleeper() NN_NOEXCEPT;

        // 以下、基底クラスからの実装必須関数
        virtual nn::TimeSpan GetTimeToTrigger(const PolicyParam& policyParam) NN_NOEXCEPT;
        virtual void HandleActiveState() NN_NOEXCEPT;
        virtual void HandleIdleState() NN_NOEXCEPT;

        // 以下、固有メソッド
        nn::os::SystemEventType* GetAutoPowerDownEvent() NN_NOEXCEPT;

    private:
        nn::os::SystemEvent m_AutoPowerDownEvent;    //!< 自動スリープを発動する際にシグナルするイベントです。
    };

}}} // namespace nn::idle::server

