﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_DeviceCode.h>

#include <nn/i2c/detail/i2c_Log.h>
#include <nn/i2c/driver/i2c.h>
#include <nn/i2c/driver/i2c_BusDev.h>

namespace nn {
namespace i2c {
namespace driver {

void Initialize() NN_NOEXCEPT
{
}

void Finalize() NN_NOEXCEPT
{
}

// [Gen2] NOT SUPPORTED
nn::Result OpenSession(I2cSession* pOutSession, nn::DeviceCode deviceCode) NN_NOEXCEPT
{
    NN_UNUSED(pOutSession);
    NN_UNUSED(deviceCode);
    NN_DETAIL_I2C_FATAL("Driver generation mismatch: Gen2 API called for Gen1 server.\n");
    NN_ABORT();
    return nn::i2c::ResultDeviceNotFound();
}

void OpenSession(I2cSession* pOutSession, I2cDevice device) NN_NOEXCEPT
{
    NN_UNUSED( pOutSession );
    NN_UNUSED( device );
}

Result Send(I2cSession& session, const void* pInData, size_t dataBytes, TransactionOption inOption) NN_NOEXCEPT
{
    NN_UNUSED( session );
    NN_UNUSED( pInData );
    NN_UNUSED( dataBytes );
    NN_UNUSED( inOption );

    return ResultSuccess();
}

Result Receive(void* pOutData, I2cSession& session, size_t dataBytes, TransactionOption inOption) NN_NOEXCEPT
{
    NN_UNUSED( pOutData );
    NN_UNUSED( session );
    NN_UNUSED( dataBytes );
    NN_UNUSED( inOption );

    return ResultSuccess();
}

Result ExecuteCommandList(void* pReceiveBuffer, size_t receiveBufferSize, I2cSession& session, const void* pCommandList, size_t commandListLength) NN_NOEXCEPT
{
    NN_UNUSED( pReceiveBuffer );
    NN_UNUSED( receiveBufferSize );
    NN_UNUSED( session );
    NN_UNUSED( pCommandList );
    NN_UNUSED( commandListLength );

    return ResultSuccess();
}

// [Gen2] NOT SUPPORTED
nn::Result SetRetryPolicy(I2cSession& session, int maxRetryCount, int retryIntervalMicroSeconds) NN_NOEXCEPT
{
    NN_UNUSED(session);
    NN_UNUSED(maxRetryCount);
    NN_UNUSED(retryIntervalMicroSeconds);
    NN_DETAIL_I2C_FATAL("Driver generation mismatch: Gen2 API called for Gen1 server.\n");
    NN_ABORT();
    return nn::i2c::ResultUnknown();
}

void CloseSession(I2cSession& session) NN_NOEXCEPT
{
    NN_UNUSED( session );
}

void OpenSessionForDev(I2cSession* pOutSession, int busIdx, Bit16 slaveAddress, AddressingMode addressingMode, SpeedMode speedMode ) NN_NOEXCEPT
{
    NN_UNUSED( pOutSession );
    NN_UNUSED( busIdx );
    NN_UNUSED( slaveAddress );
    NN_UNUSED( addressingMode );
    NN_UNUSED( speedMode );
}

void SuspendBuses() NN_NOEXCEPT
{
}

void SuspendPowerBuses() NN_NOEXCEPT
{
}


void ResumeBuses() NN_NOEXCEPT
{
}

void ResumePowerBuses() NN_NOEXCEPT
{
}



} // driver
} // i2c
} // nn
