﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/nn_Common.h>
#include <nn/dd.h>

namespace nn {
namespace i2c {
namespace driver {
namespace detail {

// 物理的なポートごとの割り込み
const nn::os::InterruptName InterruptNameI2c1 = 68;
const nn::os::InterruptName InterruptNameI2c2 = 69;
const nn::os::InterruptName InterruptNameI2c3 = 70;
#define NN_DETAIL_I2C_IRQ(bus)              (( (bus) == 0 ? InterruptNameI2c1 : \
                                               (bus) == 1 ? InterruptNameI2c2 : \
                                                            InterruptNameI2c3) )

// 物理的なポートごとのレジスタ
#define NN_DETAIL_I2C_IFDR(bus, baseAddress)  (*reinterpret_cast<volatile uint16_t *>( (baseAddress) + 0x04 + (bus) * 0x4000))
#define NN_DETAIL_I2C_I2CR(bus, baseAddress)  (*reinterpret_cast<volatile uint16_t *>( (baseAddress) + 0x08 + (bus) * 0x4000))
#define NN_DETAIL_I2C_I2SR(bus, baseAddress)  (*reinterpret_cast<volatile uint16_t *>( (baseAddress) + 0x0c + (bus) * 0x4000))
#define NN_DETAIL_I2C_I2DR(bus, baseAddress)  (*reinterpret_cast<volatile uint16_t *>( (baseAddress) + 0x10 + (bus) * 0x4000))

// データ取得用のマスク
#define NN_DETAIL_I2C_IFDR_IC(data)      ((data) & 0x3f)
#define NN_DETAIL_I2C_I2DR_DATA(data)    ((data) & 0xff)

// Control Register
enum I2cControlRegister
{
    I2cControlRegister_Ien  = (1u << 7),
    I2cControlRegister_Iien = (1u << 6),
    I2cControlRegister_Msta = (1u << 5),
    I2cControlRegister_Mtx  = (1u << 4),
    I2cControlRegister_Txak = (1u << 3),
    I2cControlRegister_Rsta = (1u << 2),
};

// Status Register
enum I2cStatusRegister
{
    I2cStatusRegister_Icf  = (1u << 7),
    I2cStatusRegister_Iaas = (1u << 6),
    I2cStatusRegister_Ibb  = (1u << 5),
    I2cStatusRegister_Ial  = (1u << 4),
    I2cStatusRegister_Srw  = (1u << 2),
    I2cStatusRegister_Iif  = (1u << 1),
    I2cStatusRegister_Rxak = (1u << 0),
};

const struct
{
    uint16_t div;
    uint8_t  ifdr;
} DivFactors[] =
{
    { 22,   0x20 }, { 24,   0x21 }, { 26,   0x22 }, { 28,   0x23 },
    { 30,   0x00 }, { 32,   0x24 }, { 36,   0x25 }, { 40,   0x26 },
    { 42,   0x03 }, { 44,   0x27 }, { 48,   0x28 }, { 52,   0x05 },
    { 56,   0x29 }, { 60,   0x06 }, { 64,   0x2A }, { 72,   0x2B },
    { 80,   0x2C }, { 88,   0x09 }, { 96,   0x2D }, { 104,  0x0A },
    { 112,  0x2E }, { 128,  0x2F }, { 144,  0x0C }, { 160,  0x30 },
    { 192,  0x31 }, { 224,  0x32 }, { 240,  0x0F }, { 256,  0x33 },
    { 288,  0x10 }, { 320,  0x34 }, { 384,  0x35 }, { 448,  0x36 },
    { 480,  0x13 }, { 512,  0x37 }, { 576,  0x14 }, { 640,  0x38 },
    { 768,  0x39 }, { 896,  0x3A }, { 960,  0x17 }, { 1024, 0x3B },
    { 1152, 0x18 }, { 1280, 0x3C }, { 1536, 0x3D }, { 1792, 0x3E },
    { 1920, 0x1B }, { 2048, 0x3F }, { 2304, 0x1C }, { 2560, 0x1D },
    { 3072, 0x1E }, { 3840, 0x1F }
};

const int      DivFactorsLength     = (sizeof(DivFactors)      / sizeof(DivFactors[0]));
const uint32_t BaseClock            = 66000000;  // HW クロック 桁あふれが起きないよう長めに設定

} // detail
} // driver
} // i2c
} // nn
