﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "htcs_NativeSocket.h"   // Windows.h より先にインクルードして、winsock.h がインクルードされるのを防止する

#include <memory>
#include <nn/nn_Result.h>
#include <nn/htcs/htcs_Types.h>
#include "htcs_AutoHandleTable.h"
#include "htcs_InternalTypes.h"
#include "htcs_Newable.h"

namespace nn { namespace htcs { namespace detail {

class ServiceResolver;
class HtcStream;

class HtcSocket : public Newable
{
    NN_DISALLOW_COPY(HtcSocket);
    NN_DISALLOW_MOVE(HtcSocket);
public:
    // socket 相当の構築。Bind か Connect を行う。
    NN_IMPLICIT HtcSocket(ServiceResolver* serviceResolver) NN_NOEXCEPT;

    // accept 相当の構築
    explicit HtcSocket(std::unique_ptr<HtcStream>&& stream) NN_NOEXCEPT;

    ~HtcSocket() NN_NOEXCEPT;

    int Bind(const struct SockAddrHtcs* address) NN_NOEXCEPT;
    int Listen(int backlogCount) NN_NOEXCEPT;

    int Accept(std::unique_ptr<HtcSocket>* outSock) NN_NOEXCEPT;
    int Connect(const struct SockAddrHtcs* address) NN_NOEXCEPT;
    //int GetPeerName(struct SockAddrHtcs* address) NN_NOEXCEPT;
    //int GetSockName(struct SockAddrHtcs* address) NN_NOEXCEPT;
    ssize_t Recv(void *buffer, size_t bufferByteSize, int flags) NN_NOEXCEPT;
    ssize_t Send(const void *buffer, size_t bufferByteSize, int flags) NN_NOEXCEPT;
    int Shutdown(int how) NN_NOEXCEPT;
    int Fcntl(int command, int value) NN_NOEXCEPT;

    int GetLastError() NN_NOEXCEPT;
private:
    void SetLastError(int errorCode) NN_NOEXCEPT;

    enum class State
    {
        None,
        Bound,
        Connected,
        Listening
    };

    State m_State;
    bool m_IsNonBlocking;
    int m_ErrorCode;

    std::unique_ptr<HtcStream> m_Stream;
    SockAddrHtcs m_BoundAddr;
    HtcServiceHandle m_ServiceHandle;
    ServiceResolver* m_ServiceResolver;
};


class SocketManager : public Newable
{
    NN_DISALLOW_COPY(SocketManager);
    NN_DISALLOW_MOVE(SocketManager);
public:
    NN_IMPLICIT SocketManager(ServiceResolver* serviceResolver) NN_NOEXCEPT;
    ~SocketManager() NN_NOEXCEPT;

    int CreateSocket() NN_NOEXCEPT;
    int Accept(int descriptor, struct SockAddrHtcs* address) NN_NOEXCEPT;
    int DestroySocket(int descriptor) NN_NOEXCEPT;

    HtcSocket* TryGetSocket(int descriptor) NN_NOEXCEPT;

private:
    AutoHandleTable<int, HtcSocket> m_SocketTable;
    ServiceResolver* m_ServiceResolver;
};

}}}
