﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   HTC 関連の実装に利用する定数
*/

#include <nn/nn_Common.h>

namespace nn { namespace htcs { namespace detail {

    // ターゲットが通信に使用するプロトコルバージョン
    const uint16_t HtcProtocolVersion = 1;

    // ターゲット起動通知パケットのサイズ
    const size_t NotifyPacketSize = 4;

    // TORIAEZU: HtcDaemon がターゲットの通知を待ち受ける UDP ポート
    const uint16_t HostNotifyReceivingUdpPort = 8009;

    // TORIAEZU: ターゲットが HtcDaemon の接続を待ち受ける TCP ポート
    const uint16_t TargetListeningTcpPort = 8009;

#define DEFINE_CONST(a) a
#define USE_VIRTUAL_SOCKETS DEFINE_CONST(1)
}}}
