﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>

#include <nn/util/util_IntrusiveList.h>

#include "../htclow_Packet.h"

namespace nn { namespace htclow { namespace server { namespace mux {

class SendBuffer final
{
    NN_DISALLOW_COPY(SendBuffer);
    NN_DISALLOW_MOVE(SendBuffer);

public:
    explicit SendBuffer(bool retransmitEnabled) NN_NOEXCEPT;
    ~SendBuffer() NN_NOEXCEPT;

    Result AddPacket(std::unique_ptr<SendPacket> packet) NN_NOEXCEPT;
    Result AddAckPacket(std::unique_ptr<SendPacket> packet) NN_NOEXCEPT;

    void RemovePacket(int64_t sequenceId) NN_NOEXCEPT;
    void RemoveAckPacket(int64_t sequenceId) NN_NOEXCEPT;

    SendPacket* GetNextPacket() NN_NOEXCEPT;

    nn::os::SystemEvent* GetEmptyEvent() NN_NOEXCEPT
    {
        return &m_EmptyEvent;
    }

private:
    void UpdateForRetransmit() NN_NOEXCEPT;

    // 同時に送信中にできるパケット数 (スライディングウィンドウサイズ)
    const int MaxSendingPacketCount = 32;

    using PacketListType = nn::util::IntrusiveList<SendPacket, nn::util::IntrusiveListBaseNodeTraits<SendPacket>>;

    // 送信データのパケットのリスト
    // ack が届いて不要になったらパケットが削除される
    PacketListType m_Packets;

    // ack パケットのリスト
    // 送信したら即座に削除される
    PacketListType m_AckPackets;

    // 送信データが空になるとシグナルされるイベント
    nn::os::SystemEvent m_EmptyEvent;

    // 追加された送信データのパケットに付与するシーケンス番号
    int64_t m_NextSequenceId;

    // 再送有効フラグ
    bool m_RetransmitEnabled;
};

}}}}
