﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/htclow/detail/htclow_DebugTypes.h>
#include <nn/htclow/detail/htclow_IDebugServiceObject.h>

namespace nn {
namespace htclow {
namespace server {

class DebugServiceObject
{
public:
    nn::Result SendFromTest(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result ReceiveFromTest(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result OpenDriver(nn::htclow::detail::DriverType driverType) NN_NOEXCEPT;
    nn::Result CloseDriver() NN_NOEXCEPT;
    nn::Result GetDefaultAllocatorUsage(nn::sf::Out<std::uint64_t> outSize) NN_NOEXCEPT;
    nn::Result PrintDefaultAllocatorUsage() NN_NOEXCEPT;
};

}}}
