﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace htcfs { namespace server {

enum class HtcfsResult : int32_t
{
    Success = 0,
    UnknownError = 1,
    UnsupportedVersion = 2,
    InvalidRequest = 3,
    InvalidHandle = 4,
    OutOfHandle = 5,
};

nn::Result ConvertHtcfsResult(int64_t htcfsResult) NN_NOEXCEPT;

nn::Result ConvertNativeResult(int64_t nativeResult) NN_NOEXCEPT;

}}}
