﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/htcfs/detail/htcfs_IServiceObject.h>

namespace nn { namespace htcfs { namespace server {

class FileSystemServiceObject
{
public:
    nn::Result GetEntryType(nn::sf::Out<std::int32_t> outType, const nn::htcfs::Path& path) NN_NOEXCEPT;
    nn::Result OpenFile(nn::sf::Out<nn::sf::SharedPointer<nn::htcfs::IFile>> outHandle, const nn::htcfs::Path& path, std::uint32_t mode) NN_NOEXCEPT;
    nn::Result CreateFile(const nn::htcfs::Path& path, std::int64_t size) NN_NOEXCEPT;
    nn::Result DeleteFile(const nn::htcfs::Path& path) NN_NOEXCEPT;
    nn::Result RenameFile(const nn::htcfs::Path& fromName, const nn::htcfs::Path& toName) NN_NOEXCEPT;
    nn::Result FileExists(nn::sf::Out<bool> outExists, const nn::htcfs::Path& path) NN_NOEXCEPT;
    nn::Result GetFileTimeStamp(nn::sf::Out<std::uint64_t> outCreateTime, nn::sf::Out<std::uint64_t> outAccessTime, nn::sf::Out<std::uint64_t> outModifyTime, const nn::htcfs::Path& path) NN_NOEXCEPT;
    nn::Result OpenDirectory(nn::sf::Out<nn::sf::SharedPointer<nn::htcfs::IDirectory>> outHandle, const nn::htcfs::Path& path, std::int32_t mode) NN_NOEXCEPT;
    nn::Result CreateDirectory(const nn::htcfs::Path& path) NN_NOEXCEPT;
    nn::Result DeleteDirectory(const nn::htcfs::Path& path, bool recursively) NN_NOEXCEPT;
    nn::Result DirectoryExists(nn::sf::Out<bool> outExists, const nn::htcfs::Path& path) NN_NOEXCEPT;
    nn::Result RenameDirectory(const nn::htcfs::Path& fromName, const nn::htcfs::Path& toName) NN_NOEXCEPT;
};

}}}
