﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/hdcp/hdcp_Result.h>
#include <nn/hdcp/hdcp_Type.h>
#include <nn/hdcp/detail/hdcp_IHdcpController.h>

namespace nn { namespace hdcp { namespace server {

// IHdcpController 実装クラス
class HdcpControllerImpl
    : public nn::sf::ISharedObject
{

public:

    HdcpControllerImpl() NN_NOEXCEPT;
    ~HdcpControllerImpl() NN_NOEXCEPT;

    Result GetHdcpStateTransitionEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandle) NN_NOEXCEPT;
    Result GetHdcpAuthenticationState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT;
    Result SetCurrentHdcpMode(std::int32_t mode) NN_NOEXCEPT;
    std::int32_t GetCurrentHdcpMode() NN_NOEXCEPT;

private:

};


}}}
