﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/os/os_EventApi.h>

#include "hdcp_NvHdcp.h"

namespace nn { namespace hdcp { namespace impl { namespace detail {

namespace {

HDCP_CLIENT_HANDLE m_Handle;

}

NvHdcp NvHdcp::m_Instance;

NvHdcp::NvHdcp() NN_NOEXCEPT
{
    m_Handle = nullptr;
}

NvHdcp::~NvHdcp() NN_NOEXCEPT
{
}

NvHdcp& NvHdcp::GetInstance() NN_NOEXCEPT
{
    return NvHdcp::m_Instance;
}

HDCP_RET_ERROR NvHdcp::Open() NN_NOEXCEPT
{
    return hdcp_open(&m_Handle, HdcpDeviceId);
}

HDCP_RET_ERROR NvHdcp::Close() NN_NOEXCEPT
{
    return hdcp_close(m_Handle);
}

HDCP_RET_ERROR NvHdcp::GetStatus() NN_NOEXCEPT
{
    return hdcp_status(m_Handle);
}

HDCP_RET_ERROR NvHdcp::Enable(bool isEnabled) NN_NOEXCEPT
{
    return hdcp_enable(m_Handle, isEnabled);
}

HDCP_RET_ERROR NvHdcp::SetTransitHandler(nvhdcp_state_transit_handler handler, void* context) NN_NOEXCEPT
{
    return hdcp_event_state_transit(m_Handle, handler, context);
}

HDCP_RET_ERROR NvHdcp::InitializeAsyncEvent() NN_NOEXCEPT
{
    return hdcp_init_asyncevents(m_Handle);
}

void NvHdcp::SetPseudoError(HDCP_RET_ERROR error) NN_NOEXCEPT
{
    // Unsupported.
}

void NvHdcp::SignalPseudoEvent(nvhdcp_state state, void* context) NN_NOEXCEPT
{
    // Unsupported.
}

}}}} // namespace nn::hdcp::impl::detail
