﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_PresenceView.h>
#include <nn/friends/detail/friends_ImplPresenceView.h>
#include <nn/friends/detail/friends_PresenceAccessor.h>
#include <nn/nn_SdkAssert.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(UserPresenceView)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(UserPresenceView)

namespace nn { namespace friends {

UserPresenceView::UserPresenceView() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

PresenceStatus UserPresenceView::GetStatus() const NN_NOEXCEPT
{
    return static_cast<PresenceStatus>(CONST_GET_IMPL()->status);
}

const ApplicationInfo& UserPresenceView::GetLastPlayedApplication() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->lastPlayedApp;
}

const nn::time::PosixTime& UserPresenceView::GetLastOnlineTime() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->lastUpdateTime;
}

const nn::time::PosixTime& UserPresenceView::GetLastUpdateTime() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->lastUpdateTime;
}

const char* UserPresenceView::GetDescription() const NN_NOEXCEPT
{
    const char* value = detail::PresenceAccessor::SearchKey("sys_description",
        CONST_GET_IMPL()->appField, sizeof (CONST_GET_IMPL()->appField));

    if (!value)
    {
        return "";
    }

    return value;
}

}}
