﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_FriendDetailedInfo.h>
#include <nn/friends/detail/friends_ImplFriendDetailedInfo.h>
#include <nn/friends/detail/friends_ApiDetail.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkAssert.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(FriendDetailedInfo)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(FriendDetailedInfo)

namespace nn { namespace friends {

FriendDetailedInfo::FriendDetailedInfo() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

nn::account::NetworkServiceAccountId FriendDetailedInfo::GetAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->profileExtra.data.accountId;
}

const PlayRecord& FriendDetailedInfo::GetLastPlayRecord() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->lastPlayRecord;
}

RequestType FriendDetailedInfo::GetRequestType() const NN_NOEXCEPT
{
    return static_cast<RequestType>(CONST_GET_IMPL()->requestType);
}

const RouteInfo& FriendDetailedInfo::GetRequestRouteInfo() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->requestRouteInfo;
}

const ExternalApplicationCatalogId& FriendDetailedInfo::GetExternalApplicationCatalogId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->requestRouteInfoExtra.candidate.catalogId;
}

const MiiName& FriendDetailedInfo::GetMiiName() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->requestRouteInfoExtra.nnid.miiName;
}

const MiiImageUrlParam& FriendDetailedInfo::GetMiiImageUrlParam() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->requestRouteInfoExtra.nnid.miiImageUrlParam;
}

nn::Result FriendDetailedInfo::GetMiiImageUrl(Url* outUrl) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outUrl);

    if (CONST_GET_IMPL()->requestType == RequestType_3Ds || CONST_GET_IMPL()->requestType == RequestType_Nnid)
    {
        NN_RESULT_DO(detail::GetMiiImageUrl(outUrl, CONST_GET_IMPL()->requestRouteInfoExtra.nnid.miiImageUrlParam));
    }
    else
    {
        outUrl->value[0] = '\0';
    }

    NN_RESULT_SUCCESS;
}

const ProfileExtra& FriendDetailedInfo::GetExtra() const NN_NOEXCEPT
{
    return reinterpret_cast<const ProfileExtra&>(CONST_GET_IMPL()->profileExtra);
}

bool FriendDetailedInfo::IsValid() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isValid;
}

}}
