﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/friends/friends_BlockedUser.h>
#include <nn/friends/detail/friends_ImplBlockedUser.h>
#include <nn/friends/detail/friends_ShimLibraryGlobal.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(BlockedUser)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(BlockedUser)

namespace nn { namespace friends {

BlockedUser::BlockedUser() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

nn::account::NetworkServiceAccountId BlockedUser::GetAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->accountId;
}

const nn::account::Nickname& BlockedUser::GetNickname() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->nickname;
}

nn::Result BlockedUser::GetProfileImageUrl(Url* outUrl, ImageSize imageSize) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outUrl);

    auto session = detail::ShimLibraryGlobal::GetInstance().GetSyncSession();

    NN_RESULT_DO(session->GetProfileImageUrl(outUrl, CONST_GET_IMPL()->profileImageUrl, static_cast<int32_t>(imageSize)));

    NN_RESULT_SUCCESS;
}

BlockReason BlockedUser::GetBlockReason() const NN_NOEXCEPT
{
    return static_cast<BlockReason>(CONST_GET_IMPL()->blockReason);
}

const RouteInfo& BlockedUser::GetRouteInfo() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->routeInfo;
}

bool BlockedUser::IsValid() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isValid;
}

}}
