﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/util/friends_HttpErrorHandler.h>
#include <nn/friends/friends_ResultPrivate.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace util {

nn::Result HandleHttpError(CURLcode code) NN_NOEXCEPT
{
    if (code == CURLE_OK)
    {
        NN_RESULT_SUCCESS;
    }

    switch (code)
    {
    case CURLE_UNSUPPORTED_PROTOCOL:
        NN_RESULT_THROW(ResultHttpErrorUnsupportedProtocol());
    case CURLE_FAILED_INIT:
        NN_RESULT_THROW(ResultHttpErrorFailedInit());
    case CURLE_URL_MALFORMAT:
        NN_RESULT_THROW(ResultHttpErrorUrlMalformat());
    case CURLE_NOT_BUILT_IN:
        NN_RESULT_THROW(ResultHttpErrorNotBuiltIn());
    case CURLE_COULDNT_RESOLVE_PROXY:
        NN_RESULT_THROW(ResultHttpErrorCouldntResolveProxy());
    case CURLE_COULDNT_RESOLVE_HOST:
        NN_RESULT_THROW(ResultHttpErrorCouldntResolveHost());
    case CURLE_COULDNT_CONNECT:
        NN_RESULT_THROW(ResultHttpErrorCouldntConnect());
    case CURLE_REMOTE_ACCESS_DENIED:
        NN_RESULT_THROW(ResultHttpErrorRemoteAccessDenied());
    case CURLE_HTTP2:
        NN_RESULT_THROW(ResultHttpErrorHttp2());
    case CURLE_PARTIAL_FILE:
        NN_RESULT_THROW(ResultHttpErrorPartialFile());
    case CURLE_QUOTE_ERROR:
        NN_RESULT_THROW(ResultHttpErrorQuoteError());
    case CURLE_HTTP_RETURNED_ERROR:
        NN_RESULT_THROW(ResultHttpErrorHttpReturnedError());
    case CURLE_WRITE_ERROR:
        NN_RESULT_THROW(ResultHttpErrorWriteError());
    case CURLE_UPLOAD_FAILED:
        NN_RESULT_THROW(ResultHttpErrorUploadFailed());
    case CURLE_READ_ERROR:
        NN_RESULT_THROW(ResultHttpErrorReadError());
    case CURLE_OUT_OF_MEMORY:
        NN_RESULT_THROW(ResultHttpErrorOutOfMemory());
    case CURLE_OPERATION_TIMEDOUT:
        NN_RESULT_THROW(ResultHttpErrorOperationTimedout());
    case CURLE_RANGE_ERROR:
        NN_RESULT_THROW(ResultHttpErrorRangeError());
    case CURLE_HTTP_POST_ERROR:
        NN_RESULT_THROW(ResultHttpErrorHttpPostError());
    case CURLE_SSL_CONNECT_ERROR:
        NN_RESULT_THROW(ResultHttpErrorSslConnectError());
    case CURLE_BAD_DOWNLOAD_RESUME:
        NN_RESULT_THROW(ResultHttpErrorBadDownloadResume());
    case CURLE_FUNCTION_NOT_FOUND:
        NN_RESULT_THROW(ResultHttpErrorFunctionNotFound());
    case CURLE_ABORTED_BY_CALLBACK:
        NN_RESULT_THROW(ResultHttpErrorAbortedByCallback());
    case CURLE_BAD_FUNCTION_ARGUMENT:
        NN_RESULT_THROW(ResultHttpErrorBadFunctionArgument());
    case CURLE_INTERFACE_FAILED:
        NN_RESULT_THROW(ResultHttpErrorInterfaceFailed());
    case CURLE_TOO_MANY_REDIRECTS:
        NN_RESULT_THROW(ResultHttpErrorTooManyRedirects());
    case CURLE_UNKNOWN_OPTION:
        NN_RESULT_THROW(ResultHttpErrorUnknownOption());
    case CURLE_PEER_FAILED_VERIFICATION:
        NN_RESULT_THROW(ResultHttpErrorPeerFailedVerification());
    case CURLE_GOT_NOTHING:
        NN_RESULT_THROW(ResultHttpErrorGotNothing());
    case CURLE_SSL_ENGINE_NOTFOUND:
        NN_RESULT_THROW(ResultHttpErrorSslEngineNotFound());
    case CURLE_SSL_ENGINE_SETFAILED:
        NN_RESULT_THROW(ResultHttpErrorSslEngineSetFailed());
    case CURLE_SEND_ERROR:
        NN_RESULT_THROW(ResultHttpErrorSendError());
    case CURLE_RECV_ERROR:
        NN_RESULT_THROW(ResultHttpErrorRecvError());
    case CURLE_SSL_CERTPROBLEM:
        NN_RESULT_THROW(ResultHttpErrorSslCertProblem());
    case CURLE_SSL_CIPHER:
        NN_RESULT_THROW(ResultHttpErrorSslCipher());
    case CURLE_SSL_CACERT:
        NN_RESULT_THROW(ResultHttpErrorSslCaCert());
    case CURLE_BAD_CONTENT_ENCODING:
        NN_RESULT_THROW(ResultHttpErrorBadContentEncoding());
    case CURLE_FILESIZE_EXCEEDED:
        NN_RESULT_THROW(ResultHttpErrorFileSizeExceeded());
    case CURLE_USE_SSL_FAILED:
        NN_RESULT_THROW(ResultHttpErrorUseSslFailed());
    case CURLE_SEND_FAIL_REWIND:
        NN_RESULT_THROW(ResultHttpErrorSendFailRewind());
    case CURLE_SSL_ENGINE_INITFAILED:
        NN_RESULT_THROW(ResultHttpErrorSslEngineInitFailed());
    case CURLE_LOGIN_DENIED:
        NN_RESULT_THROW(ResultHttpErrorLoginDenied());
    case CURLE_CONV_FAILED:
        NN_RESULT_THROW(ResultHttpErrorConvFailed());
    case CURLE_CONV_REQD:
        NN_RESULT_THROW(ResultHttpErrorConvReqd());
    case CURLE_SSL_CACERT_BADFILE:
        NN_RESULT_THROW(ResultHttpErrorSslCaCertBadFile());
    case CURLE_SSL_SHUTDOWN_FAILED:
        NN_RESULT_THROW(ResultHttpErrorSslShutdownFailed());
    case CURLE_AGAIN:
        NN_RESULT_THROW(ResultHttpErrorAgain());
    case CURLE_SSL_CRL_BADFILE:
        NN_RESULT_THROW(ResultHttpErrorSslCrlBadFile());
    case CURLE_SSL_ISSUER_ERROR:
        NN_RESULT_THROW(ResultHttpErrorSslIssuerError());
    case CURLE_CHUNK_FAILED:
        NN_RESULT_THROW(ResultHttpErrorChunkFailed());
    case CURLE_NO_CONNECTION_AVAILABLE:
        NN_RESULT_THROW(ResultHttpErrorNoConnectionAvailable());
    case CURLE_SSL_PINNEDPUBKEYNOTMATCH:
        NN_RESULT_THROW(ResultHttpErrorSslPinnedPubkeyNotMatch());
    case CURLE_SSL_INVALIDCERTSTATUS:
        NN_RESULT_THROW(ResultHttpErrorSslInvalidCertStatus());
    case CURLE_SSL_CTX_FUNCTION_NOT_SET:
        NN_RESULT_THROW(ResultHttpErrorSslCtxFunctionNotSet());
    case CURLE_SSL_CTX_INVALID:
        NN_RESULT_THROW(ResultHttpErrorSslCtxInvalid());
    case CURLE_SSL_CTX_FATAL:
        NN_RESULT_THROW(ResultHttpErrorSslCtxFatal());
    case CURLE_SSL_ALREADY_CONNECTED:
        NN_RESULT_THROW(ResultHttpErrorSslAlreadyConnected());
    case CURLE_SSL_INVALID_REFERENCE:
        NN_RESULT_THROW(ResultHttpErrorSslInvalidReference());
    default:
        NN_RESULT_THROW(ResultUnexpectedHttpError());
    }
} // NOLINT(impl/function_size)

}}}}}
