﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskUnblockUser.h>
#include <nn/friends/detail/service/core/friends_BlockedUserListManager.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

UnblockUserTask::UnblockUserTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result UnblockUserTask::SetParameter(nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    m_BlockedAccountId = accountId;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result UnblockUserTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(Account::EnsureNetworkServiceAccessToken(GetUid(), GetCancelable()));

    NN_RESULT_DO(StepUnblock());
    NN_RESULT_DO(StepSyncBlockedUserList());

    // ブロックを解除したことにより、相手からのフレンド申請が復活するかもしれない。
    NN_RESULT_DO(StepGetReceivedFriendRequestCount());

    NN_RESULT_SUCCESS;
}

nn::Result UnblockUserTask::StepUnblock() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] UnblockUserTask::StepUnblock ...\n");

    nn::account::NetworkServiceAccountId accountId = {};
    NN_RESULT_DO(Account::GetNetworkServiceAccountId(&accountId, GetUid()));

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/1.0.0/users/%016llx/blocks/%016llx", WebApi::GetFqdn(), accountId.id, m_BlockedAccountId.id);

    NN_RESULT_DO(stream.Open("DELETE", url));

    detail::service::json::JsonEventHandler handler;

    bool isNotBlocked = false;

    NN_RESULT_TRY(WebApi::Call(handler, stream, GetUid(), GetCancelable()))
        NN_RESULT_CATCH(ResultServerError404ResourceIsNotFound)
        {
            isNotBlocked = true;
        }
        NN_RESULT_CATCH(ResultNetworkServiceAccountNotExists)
        {
            isNotBlocked = true;
        }
    NN_RESULT_END_TRY;

    // ブロックの解除に成功した場合は StepSyncBlockedUserList で同期される。
    if (isNotBlocked)
    {
        // 指定したユーザーがキャッシュ上に存在するかもしれないので削除処理を実行する。
        NN_RESULT_TRY(BlockedUserListManager::GetInstance().DeleteUser(GetUid(), m_BlockedAccountId))
            NN_RESULT_CATCH(ResultNotBlocked)
            {
            }
        NN_RESULT_END_TRY;

        NN_RESULT_THROW(ResultNotBlocked());
    }

    NN_RESULT_SUCCESS;
}

}}}}}
