﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskSyncBlockedUserListBase.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerBlockedUserResourceList.h>
#include <nn/friends/detail/service/core/friends_BlockedUserListManager.h>
#include <nn/friends/detail/service/core/friends_WorkBuffer.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

nn::Result SyncBlockedUserListBaseTask::StepSyncBlockedUserList() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] SyncBlockedUserListBaseTask::StepSyncBlockedUserList ...\n");

    NN_RESULT_THROW_UNLESS(WorkBuffer::GetInstance().Acquire(GetCancelable()), ResultCanceled());

    NN_UTIL_SCOPE_EXIT
    {
        WorkBuffer::GetInstance().Release();
    };

    nn::account::NetworkServiceAccountId accountId = {};
    NN_RESULT_DO(Account::GetNetworkServiceAccountId(&accountId, GetUid()));

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/1.0.0/users/%016llx/blocks?count=%d", WebApi::GetFqdn(), accountId.id, BlockedUserCountMax);

    NN_RESULT_DO(stream.Open("GET", url));

    BlockedUserResourceListHandler handler;
    NN_RESULT_DO(handler.Initialize(WorkBuffer::GetInstance().Get(), WorkBuffer::GetInstance().GetSize()));

    NN_RESULT_DO(WebApi::Call(handler, stream, GetUid(), GetCancelable()));

    NN_RESULT_DO(BlockedUserListManager::GetInstance().UpdateBlockedUserList(GetUid(),
        handler.GetResourceList(), handler.GetResourceCount()));

    NN_RESULT_SUCCESS;
}

}}}}}
