﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskGetSnsAccountLinkPageUrl.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

GetSnsAccountLinkPageUrlTask::GetSnsAccountLinkPageUrlTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result GetSnsAccountLinkPageUrlTask::SetParameter(WebPageUrl* outUrl, SnsAccountType type) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(type == SnsAccountType_Facebook || type == SnsAccountType_Twitter, ResultInvalidArgument());

    m_OutUrl = outUrl;

    m_Type = type;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result GetSnsAccountLinkPageUrlTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(StepGetIdToken());

    nn::util::SNPrintf(m_OutUrl->value, sizeof (m_OutUrl->value), "https://api-%%.frs.srv.nintendo.net/v1/link?id_token=%s&type=%s",
        m_IdToken.value, m_Type == SnsAccountType_Facebook ? "facebook" : "twitter");

    NN_RESULT_SUCCESS;
}

nn::Result GetSnsAccountLinkPageUrlTask::StepGetIdToken() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetSnsAccountLinkPageUrlTask::StepGetIdToken ...\n");

    // 取得した URL をブラウザに渡した時に ID トークンの有効期限切れエラーになってしまうことを防ぐため、必ずリフレッシュする。
    Account::ClearNintendoAccountIdTokenForFriendCandidate();

    NN_RESULT_DO(Account::GetNintendoAccountIdTokenForFriendCandidate(&m_IdToken, GetUid(), GetCancelable()));

    NN_RESULT_SUCCESS;
}

}}}}}
