﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskGetSnsAccountFriendList.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerSnsAccountFriendResourceList.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerErrorFrs.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

GetSnsAccountFriendListTask::GetSnsAccountFriendListTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result GetSnsAccountFriendListTask::SetParameter(int* outCount, SnsAccountFriendImpl* outFriends,
    int count, SnsAccountType type) NN_NOEXCEPT
{
    NN_RESULT_THROW_UNLESS(count > 0, ResultInvalidArgument());
    NN_RESULT_THROW_UNLESS(type == SnsAccountType_Facebook || type == SnsAccountType_Twitter, ResultInvalidArgument());

    m_OutCount = outCount;
    m_OutFriends = outFriends;

    m_Count = count;
    m_Type = type;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result GetSnsAccountFriendListTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(StepGetIdToken());

    NN_RESULT_TRY(StepGetList())
        NN_RESULT_CATCH(ResultFriendRecommendServerInvalidIdToken)
        {
            NN_DETAIL_FRIENDS_INFO("[friends] The IdToken cache was judged invalidity.\n");

            Account::ClearNintendoAccountIdTokenForFriendCandidate();

            NN_RESULT_DO(StepGetIdToken());
            NN_RESULT_DO(StepGetList());
        }
    NN_RESULT_END_TRY;

    NN_RESULT_SUCCESS;
}

nn::Result GetSnsAccountFriendListTask::StepGetIdToken() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetSnsAccountFriendListTask::StepGetIdToken ...\n");

    NN_RESULT_DO(Account::GetNintendoAccountIdTokenForFriendCandidate(&m_IdToken, GetUid(), GetCancelable()));

    NN_RESULT_SUCCESS;
}

nn::Result GetSnsAccountFriendListTask::StepGetList() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetSnsAccountFriendListTask::StepGetList ...\n");

    detail::service::json::JsonHttpInputStream stream;

    char url[2048] = {};
    nn::util::SNPrintf(url, sizeof (url), "https://api-%%.frs.srv.nintendo.net/v1/friend_recommendations?id_token=%s&type=%s",
        m_IdToken.value, m_Type == SnsAccountType_Facebook ? "facebook" : "twitter");

    NN_RESULT_DO(stream.Open("GET", url));

    SnsAccountFriendResourceListHandler okHandler;
    FrsErrorHandler errorHandler;

    okHandler.Initialize(m_OutCount, m_OutFriends, m_Count);

    NN_RESULT_DO(WebApi::Call(okHandler, errorHandler, stream, GetUid(), GetCancelable(), false));

    for (int i = 0; i < *m_OutCount; i++)
    {
        m_OutFriends[i].data.type = m_Type;
    }

    NN_RESULT_SUCCESS;
}

}}}}}
