﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskGetRelationship.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerRelationship.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

GetRelationshipTask::GetRelationshipTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result GetRelationshipTask::SetParameter(Relationship* outRelationship,
        nn::account::NetworkServiceAccountId accountId) NN_NOEXCEPT
{
    m_OutRelationship = outRelationship;
    m_AccountId = accountId;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result GetRelationshipTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(Account::EnsureNetworkServiceAccessToken(GetUid(), GetCancelable()));

    NN_RESULT_DO(StepGet());

    NN_RESULT_SUCCESS;
}

nn::Result GetRelationshipTask::StepGet() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] GetRelationshipTask::StepGet ...\n");

    nn::account::NetworkServiceAccountId accountId = {};
    NN_RESULT_DO(Account::GetNetworkServiceAccountId(&accountId, GetUid()));

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/2.0.0/users/%016llx/relationships/%016llx", WebApi::GetFqdn(), accountId.id, m_AccountId.id);

    NN_RESULT_DO(stream.Open("GET", url));

    RelationshipHandler handler;
    handler.Initialize(m_OutRelationship);

    NN_RESULT_TRY(WebApi::Call(handler, stream, GetUid(), GetCancelable()))
        NN_RESULT_CATCH(ResultServerError404ResourceIsNotFound)
        {
            NN_RESULT_THROW(ResultNetworkServiceAccountNotExistsGeneral());
        }
    NN_RESULT_END_TRY;

    NN_RESULT_SUCCESS;
}

}}}}}
