﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerPresence.h>
#include <nn/friends/detail/friends_PresenceAccessor.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

PresenceHandler::PresenceHandler() NN_NOEXCEPT :
    m_Buffer(nullptr),
    m_Size(0)
{
}

void PresenceHandler::Initialize(char* buffer, size_t size) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(buffer);
    NN_SDK_REQUIRES(size > 0);

    m_Buffer = buffer;
    m_Size = size;

    std::memset(m_Buffer, 0, m_Size);
}

bool PresenceHandler::OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(length);
    NN_UNUSED(isOverflowed);

    if (jsonPath.Match("$.*"))
    {
        // "$." の次。
        const char* key = &jsonPath.ToString()[2];

        detail::PresenceAccessor::AddKeyValue(key, value, m_Buffer, m_Size);
    }

    return true;
}

}}}}}
