﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/friends_Task.h>
#include <nn/friends/detail/service/util/friends_IncrementalCounter.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

Task::Task() NN_NOEXCEPT :
    m_ContextId(detail::service::util::IncrementalCounter::GetInstance().GetValue()),
    m_Event(nn::os::EventClearMode_ManualClear),
    m_Uid(nn::account::InvalidUid),
    m_Status(Status_Initialized),
    m_Result(nn::ResultSuccess())
{
}

Task::~Task() NN_NOEXCEPT
{
}

uint64_t Task::GetContextId() NN_NOEXCEPT
{
    return m_ContextId;
}

void Task::SetUid(const nn::account::Uid& uid) NN_NOEXCEPT
{
    m_Uid = uid;
}

const nn::account::Uid& Task::GetUid() const NN_NOEXCEPT
{
    return m_Uid;
}

nn::Result Task::SetParameter() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

void Task::Run() NN_NOEXCEPT
{
    m_Event.Clear();

    nn::Result result = Main();

    if (IsCanceled())
    {
        m_Result = ResultCanceled();
    }
    else
    {
        m_Result = result;
    }

    SetStatus(Status_Completed);

    m_Event.Signal();
}

void Task::Cancel() NN_NOEXCEPT
{
    m_Cancelable.Cancel();
}

bool Task::IsCanceled() const NN_NOEXCEPT
{
    return m_Cancelable.IsCanceled();
}

void Task::Wait() NN_NOEXCEPT
{
    m_Event.Wait();
}

bool Task::TimedWait(nn::TimeSpan timeout) NN_NOEXCEPT
{
    return m_Event.TimedWait(timeout);
}

void Task::SetStatus(Status status) NN_NOEXCEPT
{
    m_Status = status;
}

Task::Status Task::GetStatus() const NN_NOEXCEPT
{
    return m_Status;
}

nn::Result Task::GetResult() const NN_NOEXCEPT
{
    return m_Result;
}

const detail::service::util::Cancelable& Task::GetCancelable() const NN_NOEXCEPT
{
    return m_Cancelable;
}

}}}}}
