﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn.fgm
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/fgm/fgm_Types.h>")]
    public struct Module
    {
    }
}

namespace nn.fgm.sf
{
    [CppRefPath(@"<nn/fgm/sfdl/fgm.sfdl.h>")]
    public interface IRequest : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Out<NativeHandle> handleOut, Module moduleId, [ProcessId] nn.Bit64 pid);

        [MethodId(1)]
        Result Set(uint32_t min, uint32_t max);

        [MethodId(2)]
        Result Get(Out<uint32_t> setting);

        [MethodId(3)]
        Result Cancel();
    }

    [CppRefPath(@"<nn/fgm/sfdl/fgm.sfdl.h>")]
    public interface ISession : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Out<IRequest> pRequestOut);
    }

    [CppRefPath(@"<nn/fgm/sfdl/fgm.sfdl.h>")]
    public interface IDebugger : IServiceObject
    {
        [MethodId(0)]
        Result Initialize(Out<NativeHandle> handleOut, NativeHandle handleIn, uint64_t memorySize);

        [MethodId(1)]
        Result Read(nn.sf.OutBuffer bufferOut, Out<uint32_t> numberReadOut, Out<uint32_t> numberLostOut, Out<uint32_t> numberRemainingOut);

        [MethodId(2)]
        Result Cancel();
    }
}
