﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/util/util_IntrusiveList.h>
#include <nn/fgm/fgm_Types.h>

#include "fgm_Request.h"

namespace nn     {
namespace fgm    {
namespace server {

typedef nn::util::IntrusiveList<Request, nn::util::IntrusiveListBaseNodeTraits<Request>> RequestList;

// This class keeps track of all min/max constraints imposed on a resource. Whenever
// constraint is added, removed or updated, a new operational point is determined using
// a governor assigned to this resource. Requests are stored in the request list
// according to priority - from higher to lower. If two requests have the same priority,
// the one which came later takes precedence.

class RequestManager
{
private:
    RequestList m_Requests;
    Setting     m_Min;
    Setting     m_Max;
    Setting     m_CurrentMin;
    Setting     m_CurrentMax;

public:
    virtual nn::Result OperatingRange(Setting min1, Setting max1, Setting min2, Setting max2, Setting* min, Setting* max)
    NN_NOEXCEPT
    {
        return nn::fgm::ResultNotSupported();
    }

    Setting     Min() const NN_NOEXCEPT { return m_CurrentMin; }
    Setting     Max() const NN_NOEXCEPT { return m_CurrentMax; }

    void        SetRange(Setting min, Setting max) NN_NOEXCEPT;
    nn::Result  UpdateOperatingRange() NN_NOEXCEPT;
    nn::Result  Add(Request* pRequestIn) NN_NOEXCEPT;
    nn::Result  Delete(Request* pRequestIn) NN_NOEXCEPT;
    nn::Result  Update(Request* pRequestIn, Setting newMin, Setting newMax) NN_NOEXCEPT;
    nn::Result  Signal() NN_NOEXCEPT;

    RequestManager() NN_NOEXCEPT;
    ~RequestManager() NN_NOEXCEPT;
};

}}}
