﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/fatalsrv/fatalsrv_CpuContext.h>
#include <nn/fatalsrv/fatalsrv_FatalContext.h>
#include <nn/fatalsrv/fatalsrv_Service.h>
#include <nn/os/os_Event.h>

namespace nn { namespace fatalsrv {
    class ITask
    {
    public:
        static const size_t DefaultRequiredStackSize = 4096;
        virtual Result Run() = 0;
        virtual const char* GetTaskName() const = 0;
        virtual size_t GetRequiredStackSize() const
        {
            return DefaultRequiredStackSize;
        }
    };

    class TaskManager
    {
    public:
        void AddTask(ITask* task) NN_NOEXCEPT;
    private:
        typedef util::IntrusiveListBaseNodeTraits<ITask> TaskTraits;
        typedef util::IntrusiveList<ITask, TaskTraits> TaskList;
        TaskList m_TaskList;
    };

    void InvokeTasks(const Service::Context& context,
        Bit64 callerProgramId,
        bool needsErrorReport,
        os::Event* errorReportWrittenEvent,
        os::Event* batteryCheckedEvent) NN_NOEXCEPT;
}} //namespace nn::fatalsrv
