﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <nn/fan/detail/fan_Log.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

#include "fan_FirmwareDebugSettingsAccessor.h"

namespace nn { namespace fan { namespace impl { namespace detail {

void FirmwareDebugSettingsAccessor::ReadSettingString(char* pOutBuffer, size_t outputBufferSize, const char* pName, const char* pSettingsName) NN_NOEXCEPT
{
    size_t targetSize = nn::settings::fwdbg::GetSettingsItemValueSize(pSettingsName, pName);

    NN_SDK_ASSERT(targetSize <= TemporaryBufferSizeForString);
    NN_SDK_ASSERT(targetSize <= outputBufferSize);

    if ( targetSize > TemporaryBufferSizeForString )
    {
        NN_DETAIL_FAN_WARN("Failed to read %s.%s(accessor's temporary buffer size was not sufficient).\n", pSettingsName, pName);
        return;
    }

    if ( targetSize > outputBufferSize )
    {
        NN_DETAIL_FAN_WARN("Failed to read %s.%s(output buffer size was not sufficient).\n", pSettingsName, pName);
        return;
    }

    uint8_t temporaryBuffer[TemporaryBufferSizeForString];
    size_t readSize = nn::settings::fwdbg::GetSettingsItemValue(temporaryBuffer, TemporaryBufferSizeForString, pSettingsName, pName);
    if ( outputBufferSize < readSize || readSize <= 0 )
    {
        NN_DETAIL_FAN_WARN("Failed to read %s.%s.\n", pSettingsName, pName);
    }
    else
    {
        std::memcpy(pOutBuffer, temporaryBuffer, readSize);
    }
}

}}}} // namespace nn::fan::impl
