﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/os.h>

namespace nn    {
namespace eupld {
namespace srv   {

class RefCount
{
private:
    static const uint32_t MaxReferenceCount = 1000;
    std::atomic<uint32_t> m_RefCount;

public:
    void AddReference()
    NN_NOEXCEPT
    {
        auto previous = m_RefCount.fetch_add(1);
        NN_ABORT_UNLESS(previous <= MaxReferenceCount);
    }

    bool RemoveReference()
    NN_NOEXCEPT
    {
        auto previous = m_RefCount.fetch_sub(1);
        NN_ABORT_UNLESS(previous != 0);
        return previous == 1;
    }

    RefCount()
    NN_NOEXCEPT :
        m_RefCount(0)
    {

    }
};

}}}
