﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/eupld/server/eupld_Server.h>
#include <nn/eupld/sfdl/eupld.sfdl.h>

namespace nn    {
namespace eupld {

struct HeapTag;
const int32_t SessionHeapSize = (8 * 1024);

class InitExpHeap
{
public:
    InitExpHeap()
    NN_NOEXCEPT
    {
        nn::sf::ExpHeapStaticAllocator
            <SessionHeapSize, HeapTag>::
            Initialize(nn::lmem::CreationOption_ThreadSafe);
    }
} g_InitExpHeap;

nn::Result GetRequestObject(nn::sf::SharedPointer<sf::IRequest> *pRequestObjectOut)
NN_NOEXCEPT
{
    return nn::sf::CreateHipcProxyByName
           <sf::IRequest, nn::sf::ExpHeapStaticAllocator
           <SessionHeapSize, HeapTag>::Policy>
           (pRequestObjectOut, RequestPortName);
}

nn::Result GetControlObject(nn::sf::SharedPointer<sf::IControl> *pControlObjectOut)
NN_NOEXCEPT
{
    return nn::sf::CreateHipcProxyByName
           <sf::IControl, nn::sf::ExpHeapStaticAllocator
           <SessionHeapSize, HeapTag>::Policy>
           (pControlObjectOut, ControlPortName);
}

}}
