﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/es/es_Types.h>
#include <nn/es/es_ActiveRightsContextTypes.h>
#include <nn/spl/spl_Types.h>
#include "es_FixedSizeVector.h"

namespace nn { namespace es {

// 1 つのアプリで管理すべきタイトル鍵の最大数（v0 + patch + AOC）
const int UsingTitleKeyCountMax = 1 + 1 + 2000;


// ActiveRightsContext 内で管理する RightsId と関連フラグを抱えた要素構造体
struct UsingTitleKey
{
    // ns から登録された RightsIdIncludingKeyId (128bit)
    union
    {
        RightsIdIncludingKeyId  rightsIdIncludingKeyId;
        fs::RightsId            fsRightsId;
    };

    // fs に登録すべきアクセスキー（128bit）
    spl::AccessKey accessKey;
};
NN_STATIC_ASSERT(sizeof(UsingTitleKey) == 16 + 16);


// ActiveRightsContextManager 内で保持する鍵リスト
typedef fixed_size_vector<UsingTitleKey, UsingTitleKeyCountMax * UsingRightsArrayCountMax> UsingTitleKeyList;


}}  // namespace nn::es
