﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/account/account_Types.h>
#include <nn/es/es_RightsApi.h>
#include "es_ETicketServiceObject.h"
#include "es_UserList.h"

namespace nn { namespace es {

Result CheckRightsStatus(RightsStatus outStatusList[], int statusCount, const nn::es::RightsIdIncludingKeyId rightsIdList[], int rightsIdCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(statusCount, rightsIdCount);

    sf::OutArray<RightsStatus> pOutStatusList(outStatusList, static_cast<size_t>(statusCount));
    sf::InArray<RightsIdIncludingKeyId> pInRightsIdList(rightsIdList, static_cast<size_t>(rightsIdCount));
    sf::InArray<ELicenseUserId> pInNaIdList;   // 要素なし

    return GetETicketServiceObject()->CheckRightsStatusIncludingKeyId(pOutStatusList, pInRightsIdList, pInNaIdList, true);
}

Result CheckRightsStatus(RightsStatus outStatusList[], int statusCount, const nn::es::RightsIdIncludingKeyId rightsIdList[], int rightsIdCount, account::NintendoAccountId naIdList[], int naIdCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(statusCount, rightsIdCount);
    NN_SDK_REQUIRES_GREATER_EQUAL(naIdCount, 1);

    sf::OutArray<RightsStatus> pOutStatusList(outStatusList, static_cast<size_t>(statusCount));
    sf::InArray<RightsIdIncludingKeyId> pInRightsIdList(rightsIdList, static_cast<size_t>(rightsIdCount));
    sf::InArray<ELicenseUserId> pInNaIdList(reinterpret_cast<ELicenseUserId*>(naIdList), static_cast<size_t>(naIdCount));

    return GetETicketServiceObject()->CheckRightsStatusIncludingKeyId(pOutStatusList, pInRightsIdList, pInNaIdList, false);
}

Result CheckRightsStatus(RightsStatus outStatusList[], int statusCount, const nn::es::RightsId rightsIdList[], int rightsIdCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(statusCount, rightsIdCount);

    sf::OutArray<RightsStatus> pOutStatusList(outStatusList, static_cast<size_t>(statusCount));
    sf::InArray<RightsId> pInRightsIdList(rightsIdList, static_cast<size_t>(rightsIdCount));
    sf::InArray<ELicenseUserId> pInNaIdList;   //要素なし

    return GetETicketServiceObject()->CheckRightsStatus(pOutStatusList, pInRightsIdList, pInNaIdList, true);
}

Result CheckRightsStatus(RightsStatus outStatusList[], int statusCount, const nn::es::RightsId rightsIdList[], int rightsIdCount, account::NintendoAccountId naIdList[], int naIdCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_EQUAL(statusCount, rightsIdCount);
    NN_SDK_REQUIRES_GREATER_EQUAL(naIdCount, 1);

    sf::OutArray<RightsStatus> pOutStatusList(outStatusList, static_cast<size_t>(statusCount));
    sf::InArray<RightsId> pInRightsIdList(rightsIdList, static_cast<size_t>(rightsIdCount));
    sf::InArray<ELicenseUserId> pInNaIdList(reinterpret_cast<ELicenseUserId*>(naIdList), static_cast<size_t>(naIdCount));

    return GetETicketServiceObject()->CheckRightsStatus(pOutStatusList, pInRightsIdList, pInNaIdList, false);
}

Result RegisterTitleKey(const nn::es::RightsIdIncludingKeyId rightsIdList[], const int keyGenerationList[], int count) NN_NOEXCEPT
{
    sf::InArray<RightsIdIncludingKeyId> pInRightsIdList(rightsIdList, static_cast<size_t>(count));
    sf::InArray<int> pInKeyGenerationList(keyGenerationList, static_cast<size_t>(count));

    return GetETicketServiceObject()->RegisterTitleKey(pInRightsIdList, pInKeyGenerationList);
}

void UnregisterAllTitleKey() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(GetETicketServiceObject()->UnregisterAllTitleKey());
}

Result RegisterAccountRestrictedRightsUser(account::NintendoAccountId naId) NN_NOEXCEPT
{
    return GetETicketServiceObject()->RegisterAccountRestrictedRightsUser(GetELicenseUserId(naId));
}

void UnregisterAllAccountRestrictedRightsUser() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(GetETicketServiceObject()->UnregisterAllAccountRestrictedRightsUser());
}

bool ListAccountRestrictedRightsUser(int* outCount, account::NintendoAccountId outNaIdList[], int count) NN_NOEXCEPT
{
    NN_SDK_ASSERT_GREATER_EQUAL(count, account::UserCountMax);

    sf::OutArray<ELicenseUserId> pOutNaIdIdList(reinterpret_cast<ELicenseUserId*>(outNaIdList), static_cast<size_t>(count));

    bool outHasAccount;
    NN_ABORT_UNLESS_RESULT_SUCCESS(GetETicketServiceObject()->ListAccountRestrictedRightsUser(&outHasAccount, outCount, pOutNaIdIdList));

    return outHasAccount;
}

}} // namespace nn::es
