﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/es/es_Configuration.h>
#include <nn/settings/fwdbg/settings_SettingsCommon.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/spl/spl_Api.h>

namespace nn { namespace es {

namespace
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    bool g_IsDevelopment = false;
#endif
    bool g_IsDebugApiEnabled = false;
    bool g_IsLocalConcurrencyCheckForDebugEnabled = false;
    bool g_IsELicenseChallengeVerificationForDebugEnabled = false;
}

void SetConfigs() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    g_IsDevelopment = nn::spl::IsDevelopment();
#endif
    g_IsDebugApiEnabled = nn::settings::fwdbg::IsDebugModeEnabled();

    // ローカル同時利用判定デバッグ設定の読み込み
    {
        bool isLocalConcurrencyCheckForDebugEnabled = false;
        size_t size = settings::fwdbg::GetSettingsItemValue(&isLocalConcurrencyCheckForDebugEnabled, sizeof(isLocalConcurrencyCheckForDebugEnabled), "es.debug", "local_concurrency_check_for_debug");
        if (size == sizeof(isLocalConcurrencyCheckForDebugEnabled) && isLocalConcurrencyCheckForDebugEnabled)
        {
            g_IsLocalConcurrencyCheckForDebugEnabled = true;
        }
        else
        {
            g_IsLocalConcurrencyCheckForDebugEnabled = false;
        }
    }

    // eLicense のチャレンジ検証のデバッグ用の読み込み
    {
        bool isELicenseChallengeVerificationForDebugEnabled = false;
        size_t size = settings::fwdbg::GetSettingsItemValue(&isELicenseChallengeVerificationForDebugEnabled, sizeof(isELicenseChallengeVerificationForDebugEnabled), "es.debug", "ignore_elicense_archive_challenge_verification_for_debug");

        if (size == sizeof(isELicenseChallengeVerificationForDebugEnabled) && isELicenseChallengeVerificationForDebugEnabled)
        {
            g_IsELicenseChallengeVerificationForDebugEnabled = true;
        }
        else
        {
            g_IsELicenseChallengeVerificationForDebugEnabled = false;
        }
    }
}

bool IsDevelopment() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    return g_IsDevelopment;
#else
    return true;
#endif
}

bool IsDebugApiEnabled() NN_NOEXCEPT
{
    return g_IsDebugApiEnabled;
}

bool IsProdMode() NN_NOEXCEPT
{
    return !g_IsDebugApiEnabled;
}

bool IsLocalConcurrencyCheckForDebugEnabled() NN_NOEXCEPT
{
    return g_IsDebugApiEnabled && g_IsLocalConcurrencyCheckForDebugEnabled;
}

bool IsELicenseChallengeVerificationForDebugEnabled() NN_NOEXCEPT
{
    return g_IsDebugApiEnabled && g_IsELicenseChallengeVerificationForDebugEnabled;
}

}} // namespace nn::es
