﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/util/util_LockGuard.h>
#include <nn/erpt/sfdl/erpt.sfdl.h>
#include <nn/erpt/server/erpt_ServerApi.h>

#include "erptsrv_IContext.h"
#include "erptsrv_ISession.h"

namespace nn   {
namespace erpt {

bool                     g_Initialized = false;
NN_ALIGNAS(4096) uint8_t g_ReportMemory[256 * 1024];
nn::os::SdkMutex         g_Lock;

nn::sf::UnmanagedServiceObject
                         <nn::erpt::sf::IContext,
                         nn::erpt::srv::IContext>
                         g_ContextSfObject;

nn::sf::UnmanagedServiceObject
                         <nn::erpt::sf::ISession,
                         nn::erpt::srv::ISession>
                         g_SessionSfObject;

void StartErptService()
NN_NOEXCEPT
{
    NN_UTIL_LOCK_GUARD(g_Lock);
    if (!g_Initialized)
    {
        nn::Result result = nn::erpt::srv::Initialize(g_ReportMemory, sizeof(g_ReportMemory));
        NN_ABORT_UNLESS_RESULT_SUCCESS(result);
        g_Initialized = true;
    }
}

nn::Result GetSessionObject(nn::sf::SharedPointer<sf::ISession> *pSessionObjectOut)
NN_NOEXCEPT
{
    StartErptService();
    *pSessionObjectOut = g_SessionSfObject.GetShared();
    return ResultSuccess();
}

void ReleaseSessionObject()
{
    return;
}

nn::Result GetContextObject(nn::sf::SharedPointer<sf::IContext> *pContextObjectOut)
NN_NOEXCEPT
{
    StartErptService();
    *pContextObjectOut = g_ContextSfObject.GetShared();
    return ResultSuccess();
}

namespace srv {

nn::Result InitializeService()
NN_NOEXCEPT
{
    return ResultSuccess();
}

void WaitService()
NN_NOEXCEPT
{
    return;
}

} // srv

}}
