﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/erpt/server/erpt_Keys.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

#include "erptsrv_Keys.h"

namespace nn   {
namespace erpt {
namespace srv  {

namespace
{
    bool IsProductionModeImpl() NN_NOEXCEPT
    {
        bool isProductionMode = true;
        if( nn::settings::fwdbg::GetSettingsItemValue(&isProductionMode, 1, "erpt", "production_mode") != 1 )
        {
            NN_SDK_LOG("[erpt]: failed to get fwdbg settings value `erpt:production_mode`. Take it as production_mode = true.\n");
            return true;
        }
        return isProductionMode;
    }

    bool IsProductionMode() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(bool, isProductionMode, = IsProductionModeImpl());
        return isProductionMode;
    }

} // ~anonymous namespace

const uint8_t* GetPublicKeyModulus() NN_NOEXCEPT
{
    return IsProductionMode() ? PublicKeyModulusForProd : PublicKeyModulusForDev;
}

size_t GetPublicKeyModulusSize() NN_NOEXCEPT
{
    return IsProductionMode() ? sizeof(PublicKeyModulusForProd) : sizeof(PublicKeyModulusForDev);
}

const uint8_t* GetPublicKeyExponent() NN_NOEXCEPT
{
    return IsProductionMode() ? PublicKeyExponentForProd : PublicKeyExponentForDev;
}

size_t GetPublicKeyExponentSize() NN_NOEXCEPT
{
    return IsProductionMode() ? sizeof(PublicKeyExponentForProd) : sizeof(PublicKeyExponentForDev);
}

}}}

