﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/util/util_StringUtil.h>
#include <nn/erpt/erpt_Report.h>

#include "erpt_Session.h"

namespace nn   {
namespace erpt {

nn::Result Report::Read(uint32_t* pReadCountOut, uint8_t* pBuffer, uint32_t bufferLength)
NN_NOEXCEPT
{
    nn::sf::OutBuffer buffer(reinterpret_cast<char*>(pBuffer), bufferLength);
    return m_pImpl != nullptr ?
           m_pImpl->Read(pReadCountOut, buffer) :
           nn::erpt::ResultNotInitialized();
}

nn::Result Report::SetFlags(ReportFlagSet flags)
NN_NOEXCEPT
{
    return m_pImpl != nullptr ?
           m_pImpl->SetFlags(flags) :
           nn::erpt::ResultNotInitialized();
}

nn::Result Report::GetFlags(ReportFlagSet* flags)
NN_NOEXCEPT
{
    return m_pImpl != nullptr ?
           m_pImpl->GetFlags(flags) :
           nn::erpt::ResultNotInitialized();
}

nn::Result Report::GetSize(int64_t* pSize)
NN_NOEXCEPT
{
    return m_pImpl != nullptr ?
           m_pImpl->GetSize(pSize) :
           nn::erpt::ResultNotInitialized();
}

nn::Result Report::Close()
NN_NOEXCEPT
{
    if (m_pImpl != nullptr)
    {
        m_pImpl->Close();
        m_pImpl = nullptr;
        ReleaseSessionObject();
    }

    return ResultSuccess();
}

nn::Result Report::Open(ReportId reportId)
NN_NOEXCEPT
{
    nn::Result result;
    nn::sf::SharedPointer<nn::erpt::sf::ISession> p_Session;

    if (m_pImpl != nullptr)
    {
        return nn::erpt::ResultAlreadyInitialized();
    }

    if ((result = GetSessionObject(&p_Session)).IsSuccess())
    {
        if ((result = p_Session->OpenReport(&m_pImpl)).IsSuccess())
        {
            result = m_pImpl->Open(reportId);
        }
        if (result.IsFailure())
        {
            p_Session = nullptr;
            m_pImpl   = nullptr;
            ReleaseSessionObject();
        }
    }

    return result;
}

Report::Report()
NN_NOEXCEPT :
    m_pImpl(nullptr)
{

}

Report::~Report()
NN_NOEXCEPT
{
    Close();
}

}}
