﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/ec_Result.h>
#include <nn/ec/ec_ResultSystem.h>
#include <nn/nim/nim_Result.h>
#include "ec_ResultUtil.h"

namespace nn { namespace ec { namespace system {
    Result Convert(Result result) NN_NOEXCEPT
    {
        if (result <= nim::ResultOutOfMaxTask()) return ResultOutOfMaxTask();
        if (result <= nim::ResultOutOfMaxRunningTask()) return ResultOutOfMaxTask();
        if (result <= nim::ResultDeviceAccountNotRegistered()) return ResultDeviceAccountNotRegistered();
        if (result <= nim::ResultDeviceNotRegistered()) return ResultDeviceNotRegistered();
        if (result <= nim::ResultInvalidDeviceAccountToken()) return ResultInvalidDeviceAccountToken();
        if (result <= nim::ResultRegisteredVirtualAccountNotFound()) return ResultRegisteredVirtualAccountNotFound();
        if (result <= nim::ResultOutOfMaxVirtualAccountRegistration()) return ResultOutOfMaxVirtualAccountRegistration();
        if (result <= nim::ResultAccountAlreadyDeviceLinked()) return ResultAccountAlreadyDeviceLinked();
        if (result <= nim::ResultTicketNotFound()) return ResultTicketNotFound();
        if (result <= nim::ResultHttpConnectionCanceled()) return ResultCanceled();
        if (result <= nim::ResultSystemUpdateRequired()) return ResultSystemUpdateRequired();
        return result;
    }
}}}
