﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <nn/ec/ec_ConsumableServiceItemApi.h>
#include "ec_AdaptorBase.h"

namespace nn { namespace ec { namespace json { namespace adaptor {

//! 消費型サービスアイテムの権利情報をデコードするための Adaptor
class ConsumableServiceItemRightDataAdaptor : public AdaptorBase<8, 128>
{
public:
    ConsumableServiceItemRightDataAdaptor(ConsumableServiceItemRightDataImpl* pOutRights, int* pOutRightCount, const int maxRightCount, void* buffer, const size_t bufferSize) NN_NOEXCEPT
        : m_pRights(pOutRights)
        , m_pRightCount(pOutRightCount)
        , m_MaxRightCount(maxRightCount)
        , m_RightIndex(0)
        , m_PathBuffer(reinterpret_cast<char*>(buffer))
        , m_PathBufferSize(bufferSize)
    {
    };

    virtual Result UpdateImpl(const JsonPathType& jsonPath, int64_t value) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result UpdateImpl(const JsonPathType& jsonPath, const char* value, int valueLength) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result NotifyObjectBeginImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result NotifyObjectEndImpl(const JsonPathType& jsonPath) NN_NOEXCEPT NN_OVERRIDE;

private:
    int MakeRightsPath(char* buffer, size_t bufferSize, const char* propertyName) NN_NOEXCEPT;
    int MakeEndPath(char* buffer, size_t bufferSize) NN_NOEXCEPT;

private:
    ConsumableServiceItemRightDataImpl* m_pRights;
    int* m_pRightCount;
    const int m_MaxRightCount;

    int m_RightIndex;
    char* m_PathBuffer;
    const size_t m_PathBufferSize;
};

}}}} //! namespace nn::ec::srv::adaptor
