﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/ec_ApiSystem.h>

#include <cstdlib>
#include <cstdarg>

#if defined( NN_BUILD_CONFIG_TOOLCHAIN_GCC )
#define STRTOULL strtoull
#elif defined( NN_BUILD_CONFIG_OS_WIN )
#define STRTOULL _strtoui64
#else
#define STRTOULL std::strtoull
#endif

namespace nn { namespace ec {

nn::ec::NsUid StringToNsUid(const char* string) NN_NOEXCEPT
{
    const char* pos = nullptr;
    nn::ec::NsUid id = { STRTOULL(string, const_cast<char**>(&pos), 10) };
    if (pos == nullptr || pos == string || *pos != '\0')
    {
        return nn::ec::NsUid::GetInvalidId();
    }
    return id;
}

nn::ec::CouponId StringToCouponId(const char* string) NN_NOEXCEPT
{
    const char* pos = nullptr;
    nn::ec::CouponId id = { STRTOULL(string, const_cast<char**>(&pos), 10) };
    if (pos == nullptr || pos == string || *pos != '\0')
    {
        return nn::ec::CouponId::GetInvalidId();
    }
    return id;
}

}}
