﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/detail/ec_ShowShopPageApi.h>

#include <string>

#include <nn/applet/applet_Types.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>
#include <nn/la/la_CommonArgumentsWriter.h>
#include <nn/ec/detail/ec_ShowShopPageTypes.h>

namespace nn { namespace ec { namespace detail {

// enum値一致のチェック
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_EndButtonPressed) == static_cast<int>(web::common::ExitReason::EndButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_BackButtonPressed) == static_cast<int>(web::common::ExitReason::BackButtonPressed));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_ExitMessage) == static_cast<int>(web::common::ExitReason::ExitMessage));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_CallbackUrlReached) == static_cast<int>(web::common::ExitReason::CallbackUrlReached));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_LastWindowDeleted) == static_cast<int>(web::common::ExitReason::LastWindowDeleted));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_LocalNetworkDisconnectionDenied) == static_cast<int>(web::common::ExitReason::LocalNetworkDisconnectionDenied));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_MediaPlayerClosed) == static_cast<int>(web::common::ExitReason::MediaPlayerClosed));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_CausedByWebPage) == static_cast<int>(web::common::ExitReason::CausedByWebPage));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_UserSelectionCanceled) == static_cast<int>(web::common::ExitReason::UserSelectionCanceled));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_NetworkConnectionFailed) == static_cast<int>(web::common::ExitReason::NetworkConnectionFailed));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_SystemUpdateRequired) == static_cast<int>(web::common::ExitReason::SystemUpdateRequired));
NN_STATIC_ASSERT(static_cast<int>(ShopExitReason_Unexpected) == static_cast<int>(web::common::ExitReason::Unexpected));

//------------------------------------------------------------------------
nn::Result ShowShopPage(ShopPageReturnValue* pOutputShopPageReturnValue,
    const ShowShopPageArg& arg) NN_NOEXCEPT
{
    auto handle = nn::web::common::CommonApi::PrepareLibraryApplet(applet::AppletId_LibraryAppletShop);

    // 共通引数をプッシュ
    nn::la::CommonArgumentsWriter writer(nn::web::common::ShimVersion, EcShimVersion);
    writer.PushToInChannel(handle);

    // ショップページを開くための起動引数をプッシュ
    arg.PushToInChannel(handle);

    // ショップページを開く
    return nn::web::common::CommonApi::StartLibraryAppletAndWait(pOutputShopPageReturnValue, sizeof(*pOutputShopPageReturnValue), handle);
}

//------------------------------------------------------------------------
nn::Result GetShopPageReturnValueFromStorage(ShopPageReturnValue* pOutputShopPageReturnValue,
    const nn::applet::StorageHandle& handle) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutputShopPageReturnValue);
    nn::web::common::CommonApi::ReadFromStorage(
        pOutputShopPageReturnValue, sizeof(*pOutputShopPageReturnValue), handle);
    return nn::ResultSuccess();
}

}}} // namespace nn::ec::detail
