﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/diag_AbortObserverForSystem.h>
#include <nn/diag/diag_AbortTypesForSystem.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Result.h>
#include <nn/am/am_Shim.h>
#include <nn/err/err_Result.h>

namespace nn { namespace diag {
    namespace {
        SdkAbortObserverHolder g_ApplicationAbortObserverHolder;

        void ApplicationDefaultAbortObserver(const SdkAbortInfo& abortInfo)
        {
            auto result = abortInfo.result.IsSuccess() ? err::ResultApplicationAbort() : abortInfo.result;
            auto tmpResult = am::GetApplicationFunctions()->SetTerminateResult(result.GetInnerValueForDebug());
            if (tmpResult.IsFailure())
            {
                NN_SDK_LOG("Warning: SetTerminateResult is missed. (0x%08x)\n", tmpResult.GetInnerValueForDebug());
            }
        }
    } // namespace

void InitializeApplicationAbortObserver() NN_NOEXCEPT
{
    InitializeSdkAbortObserverHolder(&g_ApplicationAbortObserverHolder, ApplicationDefaultAbortObserver);
    RegisterSdkAbortObserver(&g_ApplicationAbortObserverHolder);
}

}}
