﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "dhcps_Event.h"

//#define NN_DETAIL_DHCPS_LOG_LEVEL NN_DETAIL_DHCPS_LOG_LEVEL_DEBUG
#define NN_DETAIL_DHCPS_LOG_MODULE_NAME "Constants"
#include "dhcps_Log.h"

namespace nn { namespace dhcps { namespace detail {

const char* BootProtocolOperationCodeToString(BootProtocolOperationCode in) NN_NOEXCEPT
{
    switch (in)
    {
        NN_DETAIL_DHCPS_STRINGIFY_CASE(BootProtocolOperationCode::Request);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(BootProtocolOperationCode::Reply);
    default:
        ;
    };
    return "Unknown BootProtocolOperationCode";
}

const char* BootProtocolToString(BootProtocolHardwareType in) NN_NOEXCEPT
{
    switch (in)
    {
        NN_DETAIL_DHCPS_STRINGIFY_CASE(BootProtocolHardwareType::Ethernet);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(BootProtocolHardwareType::Ieee802);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(BootProtocolHardwareType::Fddi);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(BootProtocolHardwareType::Ieee1394);
    default:
        ;
    };
    return "Unknown BootProtocolHardwareType";
}

const char* DhcpOptionCodeToString(DhcpOptionCode in) NN_NOEXCEPT
{
    switch (in)
    {
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Pad);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::SubnetMask);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::TimeOffset);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Routers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::TimeServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NameServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DomainNameServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::LogServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::QuotesServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::LprServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ImpressServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RlpServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Hostname);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::BootFileSize);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::MeritDumpFile);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DomainName);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::SwapServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RootPath);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ExtensionFile);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ForwardOnOff);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::SrcRteOnOff);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::PolicyFilter);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::MaxDgAssembly);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DefaultIpTtl);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::MtuTimeout);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::MtuPlateau);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::InterfaceMtu);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::AllSubnetsLocal);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::BroadcastAddress);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::MaskDiscovery);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::MaskSupplier);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RouterDiscovery);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RouterRequest);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::StaticRoute);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Trailers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ARPTimeout);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Ethernet);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DefaultTcpTtl);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::KeepaliveTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::KeepaliveData);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NisDomain);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NisServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NtpServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::VendorSpecific);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NetbiosNameSrv);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NetbiosDistSrv);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NetbiosNodeType);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NetbiosScope);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::XWindowFont);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::XWindowManager);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RequestedAddress);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::AddressLeaseTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Overload);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DhcpMessageType);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ServerIdentifier);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ParameterList);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DhcpMessage);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DhcpMaxMessageSize);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RenewalTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RebindingTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ClassId);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ClientIdentifier);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NetwareIpDomain);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NetwareIp);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NisDomainName);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NisServerAddr);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ServerName);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::BootfileName);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::HomeAgentAddrs);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::SmtpServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Pop3Server);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NntpServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::WwwServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::FingerServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::IrcServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::StreetTalkServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::StdaServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::UserClass);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DirectoryAgent);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ServiceScope);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RapidCommit);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ClientFQDN);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RelayAgentInfo);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Isns);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NdsServers);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NdsTreeName);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NdsContext);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::BcmcsControllerDomainNameList);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::BcmcsControllerIpv4Address);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Authentication);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ClientLastTransactionTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::AssociatedIp);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ClientSystem);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ClientNDI);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Ldap);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::UuidGuid);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::UserAuth);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::GeoconfCivic);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Pcode);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Tcode);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NetinfoAddress);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NetinfoTag);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Url);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::AutoConfig);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::NameServiceSearch);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::SubnetSelection);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DomainSearch);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::SipServersDhcp);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ClasslessStaticRoute);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Ccc);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::GeoConf);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ViVendorClass);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ViVendorSpecificInformation);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::PanaAgent);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::V4Lost);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::CapWapAcv4);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Ipv4AddressMos);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Ipv4FqdnMos);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::SipUAConfigurationServiceDomains);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Ipv4AddressAndSf);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::GeoLoc);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ForceRenewOnceCapable);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RdnsSelection);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::TftpServerAddress);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::StatusCode);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::BaseTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::StartTimeOfState);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::QueryStartTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::QueryEndTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DhcpState);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DataSource);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::V4PcpServer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::V4PortParams);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::DhcpCaptivePortal);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::MudUrlV4);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::IpTelephone);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::PacketCableHome);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::PxeLinuxMagic);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::ConfigurationFile);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::PathPrefix);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::RebootTime);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::Option6Rd);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::V4AccessDomain);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::SubnetAllocation);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::VirtualSubnetVss);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpOptionCode::End);
    default:
        ;
    };
    return "Unknown DhcpOptionCode";
}; // NOLINT(impl/function_size)

const char* DhcpMessageTypeToString(DhcpMessageType in) NN_NOEXCEPT
{
    switch (in)
    {
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Discover);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Offer);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Request);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Decline);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Ack);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Nak);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Release);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Inform);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::ForceRenew);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::LeaseQuery);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::LeaseUnassigned);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::LeaseUnknown);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::LeaseActive);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::BulkLeaseQuery);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::LeaseQueryDone);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::ActiveLeaseQuery);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::LeaseQueryStatus);
        NN_DETAIL_DHCPS_STRINGIFY_CASE(DhcpMessageType::Tls);
    default:
        ;
    };
    return "Unknown DhcpMessage";
}

}}}; //nn::dhcps::detail
