﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new> // for placement new
#include <cstring>
#include <cstdlib>

#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>

#include <nn/i2c/i2c.h>
#include <nn/cpad/cpad.h>

#include "detail/cpad_Cpad.h"
#include "detail/cpad_Util.h"

namespace {

nn::util::TypedStorage< nn::cpad::detail::Cpad, sizeof(nn::cpad::detail::Cpad), sizeof(void*)>  g_Cpad;

bool g_IsCpadInitialized = false;

nn::cpad::detail::Cpad& GetCpad() NN_NOEXCEPT
{
    return reinterpret_cast<nn::cpad::detail::Cpad&>( g_Cpad );
}

}


namespace nn {
namespace cpad {

void   InitializeCpad() NN_NOEXCEPT
{
    if( g_IsCpadInitialized )
    {
        return;
    }

    new(&g_Cpad) detail::Cpad; // placement new で初期化
    g_IsCpadInitialized = true;

    GetCpad().InitializeCpad();
}

Result GetCpadState(CpadState* pOutState) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(g_IsCpadInitialized);
    NN_SDK_REQUIRES_NOT_NULL(pOutState);

    return GetCpad().GetCpadState(pOutState);
}

bool HasCpadChange(const CpadState *pInStates, int statesCount) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(g_IsCpadInitialized);
    NN_SDK_REQUIRES_NOT_NULL(pInStates);
    NN_SDK_REQUIRES( statesCount > 0 );

    return GetCpad().HasCpadChange(pInStates, statesCount);
}

bool HasCpadInput(CpadState state) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(g_IsCpadInitialized);
    return GetCpad().HasCpadInput(state);
}

bool CalibrateCpad() NN_NOEXCEPT
{
    NN_SDK_REQUIRES(g_IsCpadInitialized);
    return GetCpad().CalibrateCpad();
}

} // cpad
} // nn
