﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace cec { namespace detail {

/* one touch play feature */
const uint8_t CecOpcodeImageViewOn              = 0x04; /* direct, none */
const uint8_t CecOpcodeTextViewOn               = 0x0D; /* direct, none */
const uint8_t CecOpcodeActiveSource             = 0x82; /* broadcast, [phy adx] */
/* routing control feature, also includes active source */
const uint8_t CecOpcodeRoutingChange            = 0x80; /* broadcast, [original adx][new adx] */
const uint8_t CecOpcodeRoutingInformation       = 0x81; /* broadcast, [phy adx] */
const uint8_t CecOpcodeRequestActiveSource      = 0x85; /* broadcast, none */
const uint8_t CecOpcodeSetStreamPath            = 0x86; /* broadcast, [phy adx] */
const uint8_t CecOpcodeInactiveSource           = 0x9D; /* direct, [phy adx] */
/* standby feature */
const uint8_t CecOpcodeStandby                  = 0x36; /* direct and broadcast, none */
/* system information feature set, also include cec version commands */
const uint8_t CecOpcodeSetMenuLanguage          = 0x32; /* broadcast, [Language] */
const uint8_t CecOpcodeGivePhysicalAddress      = 0x83; /* direct, none */
const uint8_t CecOpcodeReportPhysicalAddress    = 0x84; /* broadcast, [phy adx][dev type] */
const uint8_t CecOpcodeGetMenuLanguage          = 0x91; /* direct, none */
/* vendor specific command feature opcode set */
const uint8_t CecOpcodeDeviceVendorId           = 0x87; /* broadcast, [Vendor ID] */
const uint8_t CecOpcodeVendorCommand            = 0x89; /* direct [Vendor Specific Data] */
const uint8_t CecOpcodeVendorRemoteButtonDown   = 0x8A; /* direct or broadcast, [Vendor Specific RC Code] */
const uint8_t CecOpcodeVendorRemoteButtonUp     = 0x8B; /* direct or broadcast, none */
const uint8_t CecOpcodeGiveDeviceVendorId       = 0x8C; /* direct, none */
const uint8_t CecOpcodeCecVersion               = 0x9E; /* direct [CEC Version] */
const uint8_t CecOpcodeGetCecVersion            = 0x9F; /* direct, none */
const uint8_t CecOpcodeVendorCommandWithId      = 0xA0; /* direct or broadcast, [Vendor ID][Vend. Sp. Data] */
/* device menu control */
const uint8_t CecOpcodeMenuRequest              = 0x8D; /* direct [Menu Request] */
const uint8_t CecOpcodeMenuStatus               = 0x8E; /* direct [Menu State] */
const uint8_t CecOpcodeUserControlPressed       = 0x44; /* direct [UI Command] */
const uint8_t CecOpcodeUserControlReleased      = 0x45; /* direct, none */
/* power status */
const uint8_t CecOpcodeGiveDevicePowerStatus    = 0x8F; /* direct, none */
const uint8_t CecOpcodeReportPowerStatus        = 0x90; /* direct, [power status] */
/* OSD */
const uint8_t CecOpcodeGiveOsdName              = 0x46; /* direct, none */
const uint8_t CecOpcodeSetOsdName               = 0x47; /* direct, [OSD name] */
const uint8_t CecOpcodeSetOsdString             = 0x64; /* direct, [Display Control][OSD string] */
/* general protocol */
const uint8_t CecOpcodeFeatureAbort             = 0x00; /* direct, [feature opcode][abort reason] */
const uint8_t CecOpcodeAbort                    = 0xFF; /* direct, none */

/* related things, constants */
const uint8_t CecAbortReasonUnrecognizedOpcode  = 0;    /* one byte */
const uint8_t CecAbortReasonNotCorrectMode      = 1;
const uint8_t CecAbortReasonCannotProvideSource = 2;
const uint8_t CecAbortReasonInvalidOperand      = 3;
const uint8_t CecAbortReasonRefused             = 4;
const uint8_t CecAbortReasonReserved            = 5;

const uint8_t CecDisplayControlDefaultTime      = (0 << 6);
const uint8_t CecDisplayControlUntilCleared     = (1 << 6);
const uint8_t CecDisplayControlPreviousMessage  = (2 << 6);
const uint8_t CecDisplayControlReserved         = (3 << 6);

const uint8_t CecDeviceTypePlaybackDevice       = 4;    /* one byte */

const uint8_t CecDeviceVendorIdLow              = 0x00; /* three bytes */
const uint8_t CecDeviceVendorIdMid              = 0x09;
const uint8_t CecDeviceVendorIdHigh             = 0xBF;

const uint8_t CecVersionNumber11                = 0x00; /* one byte */
const uint8_t CecVersionNumber12                = 0x01;
const uint8_t CecVersionNumber12a               = 0x02;
const uint8_t CecVersionNumber13                = 0x03;
const uint8_t CecVersionNumber13a               = 0x04;

const uint8_t CecPowerStatusOn                  = 0x00; /* one byte */
const uint8_t CecPowerStatusStandby             = 0x01;
const uint8_t CecPowerStatusTransitionToOn      = 0x02;
const uint8_t CecPowerStatusTransitionToStandby = 0x03;

const uint8_t CecMenuRequestTypeActivate        = 0x00;
const uint8_t CecMenuRequestTypeDeactivate      = 0x01;
const uint8_t CecMenuRequestTypeQuery           = 0x02;

const uint8_t CecMenuStateActivated             = 0x00;
const uint8_t CecMenuStateDeactivated           = 0x01;
const uint8_t CecMenuStateInvalidState          = 0xFF;

const uint8_t CecUiCommandVolumeUp              = 0x41;
const uint8_t CecUiCommandVolumeDown            = 0x42;
const uint8_t CecUiCommandVolumeMute            = 0x43;

const uint8_t CecUiCommandPowerOn               = 0x6D;

}
}   // namespace cec
}   // namespace nn
