﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

class Win32KeyboardBuffer
{
    NN_DISALLOW_COPY(Win32KeyboardBuffer);
    NN_DISALLOW_MOVE(Win32KeyboardBuffer);

public:

    Win32KeyboardBuffer() NN_NOEXCEPT {};
    ~Win32KeyboardBuffer() NN_NOEXCEPT {};

    Result Initialize(uint8_t* pBuffer, uint32_t entries, uint32_t entrySize) NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;
    Result Put(uint8_t* pSrc) NN_NOEXCEPT;
    Result Get(uint8_t* pDst, uint32_t* pBytesReceived) NN_NOEXCEPT;

private:

    uint8_t*                m_pBuffer;
    uint32_t                m_BufferEntries;
    uint32_t                m_BufferSize;

    uint32_t                m_PutEntry;
    uint32_t                m_GetEntry;
    uint32_t                m_Entries;

    nn::os::SemaphoreType   m_Semaphore;
};

} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn

